/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.provider.datastax;

import com.github.cassandra.jdbc.CassandraErrors;
import com.github.cassandra.jdbc.internal.datastax.driver.core.Cluster;
import com.github.cassandra.jdbc.internal.datastax.driver.core.DataStaxClusterHelper;
import com.github.cassandra.jdbc.internal.datastax.driver.core.Metadata;
import com.github.cassandra.jdbc.internal.datastax.driver.core.PreparedStatement;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ResultSet;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ResultSetFuture;
import com.github.cassandra.jdbc.internal.datastax.driver.core.Session;
import com.github.cassandra.jdbc.internal.datastax.driver.core.Statement;
import com.github.cassandra.jdbc.internal.tinylog.Logger;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;

final class DataStaxSessionWrapper
implements AutoCloseable {
    private final AtomicInteger references = new AtomicInteger(0);
    private Session session;

    DataStaxSessionWrapper(Session session) {
        this.session = session;
    }

    private void validateState() throws SQLException {
        if (this.session == null || this.session.isClosed()) {
            this.session = null;
            throw CassandraErrors.connectionClosedException();
        }
    }

    ResultSet execute(Statement statement) throws SQLException {
        this.validateState();
        return this.session.execute(statement);
    }

    ResultSetFuture executeAsync(Statement statement) throws SQLException {
        this.validateState();
        return this.session.executeAsync(statement);
    }

    Metadata getClusterMetaData() throws SQLException {
        this.validateState();
        return this.session.getCluster().getMetadata();
    }

    PreparedStatement prepare(String cql) throws SQLException {
        this.validateState();
        return this.session.prepare(cql);
    }

    String getLoggedKeyspace() throws SQLException {
        this.validateState();
        return this.session.getLoggedKeyspace();
    }

    void open() {
        this.references.incrementAndGet();
    }

    boolean isClosed() {
        return this.session == null || this.session.isClosed();
    }

    @Override
    public void close() throws Exception {
        if ((this.session == null || this.references.decrementAndGet() <= 0) && this.session != null) {
            Cluster cluster = this.session.getCluster();
            if (DataStaxClusterHelper.hasLiveSessions(cluster)) {
                cluster.closeAsync().force();
                Logger.info("Closing cluster@{} and all sessions underneath", cluster.hashCode());
            } else {
                this.session.close();
                Logger.info("Session@{} is closed", this.session.hashCode());
            }
            this.session = null;
        }
    }
}

