/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.provider.datastax;

import com.github.cassandra.jdbc.CassandraConfiguration;
import com.github.cassandra.jdbc.internal.datastax.driver.core.Cluster;
import com.github.cassandra.jdbc.internal.datastax.driver.core.CodecRegistry;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ConsistencyLevel;
import com.github.cassandra.jdbc.internal.datastax.driver.core.Host;
import com.github.cassandra.jdbc.internal.datastax.driver.core.HostDistance;
import com.github.cassandra.jdbc.internal.datastax.driver.core.Metadata;
import com.github.cassandra.jdbc.internal.datastax.driver.core.PoolingOptions;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ProtocolOptions;
import com.github.cassandra.jdbc.internal.datastax.driver.core.QueryOptions;
import com.github.cassandra.jdbc.internal.datastax.driver.core.SocketOptions;
import com.github.cassandra.jdbc.internal.datastax.driver.core.TypeCodec;
import com.github.cassandra.jdbc.internal.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.github.cassandra.jdbc.internal.datastax.driver.core.policies.RoundRobinPolicy;
import com.github.cassandra.jdbc.internal.datastax.driver.extras.codecs.joda.InstantCodec;
import com.github.cassandra.jdbc.internal.datastax.driver.extras.codecs.joda.LocalDateCodec;
import com.github.cassandra.jdbc.internal.datastax.driver.extras.codecs.joda.LocalTimeCodec;
import com.github.cassandra.jdbc.internal.google.common.base.Splitter;
import com.github.cassandra.jdbc.internal.google.common.base.Strings;
import com.github.cassandra.jdbc.internal.google.common.cache.Cache;
import com.github.cassandra.jdbc.internal.google.common.cache.CacheBuilder;
import com.github.cassandra.jdbc.internal.google.common.cache.RemovalListener;
import com.github.cassandra.jdbc.internal.google.common.cache.RemovalNotification;
import com.github.cassandra.jdbc.internal.google.common.reflect.ClassPath;
import com.github.cassandra.jdbc.internal.tinylog.Logger;
import com.github.cassandra.jdbc.provider.datastax.DataStaxSessionWrapper;
import com.github.cassandra.jdbc.provider.datastax.codecs.JavaSqlTimeCodec;
import java.util.concurrent.Callable;

final class DataStaxSessionFactory {
    private static final Cache<String, DataStaxSessionWrapper> _sessionCache = CacheBuilder.newBuilder().weakValues().removalListener(new RemovalListener<String, DataStaxSessionWrapper>(){

        @Override
        public void onRemoval(RemovalNotification<String, DataStaxSessionWrapper> notification) {
            DataStaxSessionWrapper session = notification.getValue();
            Logger.debug("Closing [{}] (cause: {})...", new Object[]{session, notification.getCause()});
            if (session != null) {
                try {
                    session.close();
                }
                catch (Throwable t) {
                    Logger.debug(t, "Error occurred when closing session", new Object[0]);
                }
            }
            Logger.debug("Closed [{0}].", session);
        }
    }).build();

    DataStaxSessionFactory() {
    }

    private static DataStaxSessionWrapper newSession(CassandraConfiguration config) {
        return DataStaxSessionFactory.newSession(config, null);
    }

    private static DataStaxSessionWrapper newSession(CassandraConfiguration config, String keyspace) {
        keyspace = Strings.isNullOrEmpty(keyspace) || config.getKeyspace().equals(keyspace) ? config.getKeyspace() : keyspace;
        Logger.debug("Connecting to [{}]...", config.getConnectionUrl());
        Cluster.Builder builder = Cluster.builder();
        for (String host : Splitter.on(',').trimResults().omitEmptyStrings().split(config.getHosts())) {
            builder.addContactPoint(host);
        }
        if (config.getPort() > 0) {
            builder.withPort(config.getPort());
        }
        SocketOptions socketOptions = new SocketOptions();
        socketOptions.setConnectTimeoutMillis(config.getConnectionTimeout());
        socketOptions.setReadTimeoutMillis(config.getReadTimeout());
        socketOptions.setKeepAlive(config.isKeepAlive());
        builder.withSocketOptions(socketOptions);
        QueryOptions queryOptions = new QueryOptions();
        queryOptions.setConsistencyLevel(ConsistencyLevel.valueOf(config.getConsistencyLevel().name()));
        if (config.getFetchSize() > 0) {
            queryOptions.setFetchSize(config.getFetchSize());
        }
        builder.withQueryOptions(queryOptions);
        PoolingOptions poolOptions = new PoolingOptions();
        poolOptions.setConnectionsPerHost(HostDistance.LOCAL, config.getAdditionalProperty("corePoolLocal", 1), config.getAdditionalProperty("maxPoolLocal", 1));
        poolOptions.setConnectionsPerHost(HostDistance.REMOTE, config.getAdditionalProperty("corePoolRemote", 1), config.getAdditionalProperty("maxPoolRemote", 1));
        poolOptions.setIdleTimeoutSeconds(config.getAdditionalProperty("idleTimeoutSeconds", poolOptions.getIdleTimeoutSeconds()));
        poolOptions.setPoolTimeoutMillis(config.getAdditionalProperty("poolTimeoutMillis", poolOptions.getPoolTimeoutMillis()));
        poolOptions.setHeartbeatIntervalSeconds(config.getAdditionalProperty("heartbeatIntervalSeconds", poolOptions.getHeartbeatIntervalSeconds()));
        poolOptions.setMaxRequestsPerConnection(HostDistance.LOCAL, config.getAdditionalProperty("maxRequestsPerConnectionLocal", 800));
        poolOptions.setMaxRequestsPerConnection(HostDistance.REMOTE, config.getAdditionalProperty("maxRequestsPerConnectionRemote", 200));
        poolOptions.setNewConnectionThreshold(HostDistance.LOCAL, config.getAdditionalProperty("newConnectionThresholdLocal", 1024));
        poolOptions.setNewConnectionThreshold(HostDistance.REMOTE, config.getAdditionalProperty("newConnectionThresholdRemote", 256));
        builder.withPoolingOptions(poolOptions);
        builder.withCompression(ProtocolOptions.Compression.valueOf(config.getCompression().name()));
        CodecRegistry registry = new CodecRegistry();
        registry.register(LocalDateCodec.instance, LocalTimeCodec.instance, InstantCodec.instance);
        String packageName = JavaSqlTimeCodec.class.getPackage().getName();
        try {
            for (ClassPath.ClassInfo info : ClassPath.from(DataStaxSessionFactory.class.getClassLoader()).getTopLevelClasses()) {
                if (!packageName.equals(info.getPackageName())) continue;
                Logger.debug("Registering codec: {}", info.getName());
                registry.register((TypeCodec<?>)((TypeCodec)info.load().getField("instance").get(null)));
            }
        }
        catch (Exception e) {
            Logger.warn(e, "Failed to register codec", new Object[0]);
        }
        builder.withCodecRegistry(registry);
        if (!Strings.isNullOrEmpty(config.getLocalDc())) {
            builder.withLoadBalancingPolicy(DCAwareRoundRobinPolicy.builder().withLocalDc(config.getLocalDc()).build());
        } else {
            builder.withLoadBalancingPolicy(new RoundRobinPolicy());
        }
        Cluster cluster = builder.withCredentials(config.getUserName(), config.getPassword()).build();
        Logger.debug("Connected to [{}({})] successfully", config.getConnectionUrl(), cluster.hashCode());
        Metadata metadata = cluster.getMetadata();
        Logger.info("Connected to cluster@{}: {}", cluster.hashCode(), metadata.getClusterName());
        for (Host host : metadata.getAllHosts()) {
            Logger.info("-> Datacenter: {}, Host: {}, Rack: {}", host.getDatacenter(), host.getAddress(), host.getRack());
        }
        return new DataStaxSessionWrapper(cluster.connect(keyspace));
    }

    static DataStaxSessionWrapper getSession(CassandraConfiguration config) {
        return DataStaxSessionFactory.getSession(config, null);
    }

    static DataStaxSessionWrapper getSession(final CassandraConfiguration config, String keyspace) {
        final String targetKeyspace = Strings.isNullOrEmpty(keyspace) || config.getKeyspace().equals(keyspace) ? config.getKeyspace() : keyspace;
        DataStaxSessionWrapper session = null;
        try {
            session = _sessionCache.get(config.getConnectionUrl(), new Callable<DataStaxSessionWrapper>(){

                @Override
                public DataStaxSessionWrapper call() throws Exception {
                    return DataStaxSessionFactory.newSession(config, targetKeyspace);
                }
            });
            if (session.isClosed() || !session.getLoggedKeyspace().equals(targetKeyspace)) {
                _sessionCache.invalidate(config.getConnectionUrl());
                session = DataStaxSessionFactory.getSession(config, targetKeyspace);
            }
            session.open();
        }
        catch (Exception e) {
            Logger.error(e, "Failed to obtain session object", new Object[0]);
            throw new RuntimeException(e);
        }
        return session;
    }
}

