/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.provider.datastax;

import com.github.cassandra.jdbc.CassandraDataTypeConverters;
import com.github.cassandra.jdbc.CassandraDataTypeMappings;
import com.github.cassandra.jdbc.internal.datastax.driver.core.utils.UUIDs;
import com.github.cassandra.jdbc.internal.google.common.base.Function;
import com.github.cassandra.jdbc.internal.joda.time.LocalDate;
import com.github.cassandra.jdbc.internal.joda.time.LocalTime;
import java.sql.Time;
import java.util.Date;
import java.util.UUID;

final class DataStaxDataTypes
extends CassandraDataTypeMappings {
    static final CassandraDataTypeMappings mappings = CassandraDataTypeMappings.instance;
    static final CassandraDataTypeConverters converters = new CassandraDataTypeConverters(){

        @Override
        protected void init() {
            super.init();
            this.addMapping(com.github.cassandra.jdbc.internal.datastax.driver.core.LocalDate.class, com.github.cassandra.jdbc.internal.datastax.driver.core.LocalDate.fromMillisSinceEpoch(System.currentTimeMillis()), new Function<Object, com.github.cassandra.jdbc.internal.datastax.driver.core.LocalDate>(){

                @Override
                public com.github.cassandra.jdbc.internal.datastax.driver.core.LocalDate apply(Object input) {
                    com.github.cassandra.jdbc.internal.datastax.driver.core.LocalDate date = input instanceof Date ? com.github.cassandra.jdbc.internal.datastax.driver.core.LocalDate.fromMillisSinceEpoch(((Date)input).getTime()) : com.github.cassandra.jdbc.internal.datastax.driver.core.LocalDate.fromMillisSinceEpoch(java.sql.Date.valueOf(String.valueOf(input)).getTime());
                    return date;
                }
            });
            this.addMapping(UUID.class, UUIDs.timeBased(), new Function<Object, UUID>(){

                @Override
                public UUID apply(Object input) {
                    return UUID.fromString(String.valueOf(input));
                }
            });
            this.addMapping(java.sql.Date.class, new java.sql.Date(System.currentTimeMillis()), new Function<Object, java.sql.Date>(){

                @Override
                public java.sql.Date apply(Object input) {
                    java.sql.Date date;
                    if (input instanceof com.github.cassandra.jdbc.internal.datastax.driver.core.LocalDate) {
                        com.github.cassandra.jdbc.internal.datastax.driver.core.LocalDate localDate = (com.github.cassandra.jdbc.internal.datastax.driver.core.LocalDate)input;
                        date = new java.sql.Date(new LocalDate(localDate.getYear(), localDate.getMonth(), localDate.getDay()).toDate().getTime());
                    } else {
                        date = input instanceof LocalDate ? new java.sql.Date(((LocalDate)input).toDate().getTime()) : (input instanceof Date ? new java.sql.Date(((Date)input).getTime()) : (input instanceof Number ? new java.sql.Date(((Number)input).longValue()) : java.sql.Date.valueOf(String.valueOf(input))));
                    }
                    return date;
                }
            });
            this.addMapping(Time.class, new Time(System.currentTimeMillis()), new Function<Object, Time>(){

                @Override
                public Time apply(Object input) {
                    Time time;
                    if (input instanceof LocalTime) {
                        time = new Time(((LocalTime)input).toDateTimeToday().getMillis());
                    } else if (input instanceof Date) {
                        time = new Time(((Date)input).getTime());
                    } else if (input instanceof Number) {
                        long possibllyNanoSeconds = ((Number)input).longValue();
                        if (possibllyNanoSeconds % 1000000L == 0L) {
                            possibllyNanoSeconds /= 1000000L;
                        }
                        time = new Time(LocalTime.fromMillisOfDay(possibllyNanoSeconds).toDateTimeToday().getMillis());
                    } else {
                        time = new Time(LocalTime.parse(String.valueOf(input)).toDateTimeToday().getMillis());
                    }
                    return time;
                }
            });
        }
    };

    DataStaxDataTypes() {
    }
}

