/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.provider.datastax;

import com.github.cassandra.jdbc.BaseCassandraPreparedStatement;
import com.github.cassandra.jdbc.CassandraCqlParser;
import com.github.cassandra.jdbc.CassandraCqlStatement;
import com.github.cassandra.jdbc.CassandraCqlStmtConfiguration;
import com.github.cassandra.jdbc.CassandraDataTypeConverters;
import com.github.cassandra.jdbc.CassandraDataTypeMappings;
import com.github.cassandra.jdbc.CassandraEnums;
import com.github.cassandra.jdbc.CassandraErrors;
import com.github.cassandra.jdbc.CassandraStatementType;
import com.github.cassandra.jdbc.internal.datastax.driver.core.BatchStatement;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ConsistencyLevel;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ExecutionInfo;
import com.github.cassandra.jdbc.internal.datastax.driver.core.QueryTrace;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ResultSet;
import com.github.cassandra.jdbc.internal.datastax.driver.core.SimpleStatement;
import com.github.cassandra.jdbc.internal.datastax.driver.core.Statement;
import com.github.cassandra.jdbc.internal.google.common.base.Strings;
import com.github.cassandra.jdbc.internal.tinylog.Level;
import com.github.cassandra.jdbc.internal.tinylog.Logger;
import com.github.cassandra.jdbc.provider.datastax.CassandraConnection;
import com.github.cassandra.jdbc.provider.datastax.CassandraResultSet;
import com.github.cassandra.jdbc.provider.datastax.DataStaxDataTypes;
import com.github.cassandra.jdbc.provider.datastax.DataStaxSessionWrapper;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class CassandraStatement
extends BaseCassandraPreparedStatement {
    private static final Level LOG_LEVEL = Logger.getLevel(CassandraStatement.class);
    protected CassandraResultSet currentResultSet;
    protected DataStaxSessionWrapper session;

    protected CassandraStatement(CassandraConnection conn, DataStaxSessionWrapper session) {
        this(conn, session, "");
    }

    protected CassandraStatement(CassandraConnection conn, DataStaxSessionWrapper session, String cql) {
        super(conn, cql);
        this.session = session;
    }

    @Override
    protected CassandraDataTypeMappings getDataTypeMappings() {
        return DataStaxDataTypes.mappings;
    }

    @Override
    protected CassandraDataTypeConverters getDataTypeConverters() {
        return DataStaxDataTypes.converters;
    }

    protected void configureStatement(Statement stmt, CassandraCqlStmtConfiguration config) throws SQLException {
        stmt.setConsistencyLevel(ConsistencyLevel.valueOf(config.getConsistencyLevel()));
        String scl = config.getSerialConsistencyLevel();
        if (!Strings.isNullOrEmpty(scl)) {
            stmt.setSerialConsistencyLevel(ConsistencyLevel.valueOf(scl));
        }
        stmt.setFetchSize(config.hasSetFetchSize() ? config.getFetchSize() : this.getFetchSize());
        if (config.tracingEnabled()) {
            stmt.enableTracing();
        }
        stmt.setReadTimeoutMillis(config.getReadTimeout());
    }

    protected void postStatementExecution(CassandraCqlStatement parsedStmt, ResultSet rs) {
        if (LOG_LEVEL.compareTo(Level.DEBUG) >= 0 && rs != null) {
            int size;
            List<ExecutionInfo> list = rs.getAllExecutionInfo();
            int n = size = list == null ? 0 : list.size();
            if (size > 0) {
                int index = 1;
                for (ExecutionInfo info : rs.getAllExecutionInfo()) {
                    Logger.debug(this.getExecutionInfoAsString(info, index, size));
                    QueryTrace q = info.getQueryTrace();
                    if (parsedStmt.getConfiguration().tracingEnabled() && q != null) {
                        Logger.debug(this.getQueryTraceAsString(q, index, size));
                    }
                    ++index;
                }
                Logger.debug("Executed successfully with results: {}", !rs.isExhausted());
            }
        }
        this.replaceCurrentResultSet(parsedStmt, rs);
    }

    protected ResultSet executeCql(String cql) throws SQLException {
        Logger.debug("Trying to execute the following CQL:\n{}", cql);
        CassandraCqlStatement parsedStmt = CassandraCqlParser.parse(this.getConfiguration(), cql);
        CassandraCqlStmtConfiguration stmtConf = parsedStmt.getConfiguration();
        Logger.debug("Statement Configuration:\n{}", stmtConf);
        SimpleStatement ss = new SimpleStatement(parsedStmt.getCql());
        this.configureStatement(ss, stmtConf);
        ResultSet rs = null;
        if (stmtConf.noWait()) {
            this.session.executeAsync(ss);
        } else {
            rs = this.session.execute(ss);
        }
        this.postStatementExecution(parsedStmt, rs);
        return rs;
    }

    protected String getExecutionInfoAsString(ExecutionInfo info, int index, int size) {
        StringBuilder builder = new StringBuilder();
        if (info != null) {
            builder.append("Execution Info ").append(index).append(" of ").append(size).append(":\n* schema agreement: ").append(info.isSchemaInAgreement()).append("\n* achieved consistency level: ").append((Object)info.getAchievedConsistencyLevel()).append("\n* queried host: ").append(info.getQueriedHost()).append("\n* tried hosts: ").append(info.getTriedHosts()).append("\n* paging state: ").append(info.getPagingState());
        }
        return builder.toString();
    }

    protected String getQueryTraceAsString(QueryTrace q, int index, int size) {
        StringBuilder trace = new StringBuilder();
        if (q != null) {
            trace.append("Query Trace ").append(index).append(" of ").append(size).append(": \n[ id=").append(q.getTraceId()).append(", coordinator=").append(q.getCoordinator()).append(", requestType=").append(q.getRequestType()).append(", startAt=").append(new Timestamp(q.getStartedAt())).append(", duration=").append(q.getDurationMicros()).append("(microseconds), params=").append(q.getParameters()).append(" ]");
            for (QueryTrace.Event e : q.getEvents()) {
                trace.append("\n* event=[").append(e.getDescription()).append("], location=[").append(e.getThreadName()).append("@").append(e.getSource()).append("], time=[").append(new Timestamp(e.getTimestamp())).append("], elapsed=[").append(e.getSourceElapsedMicros()).append("(microseconds)]");
            }
        }
        return trace.toString();
    }

    protected void replaceCurrentResultSet(CassandraCqlStatement parsedStmt, ResultSet resultSet) {
        this.cqlStmt = parsedStmt;
        if (this.currentResultSet != null) {
            try {
                if (!this.currentResultSet.isClosed()) {
                    this.currentResultSet.close();
                }
            }
            catch (Throwable t) {
                Logger.warn(t, "Not able to close the old result set: {}", this.currentResultSet);
            }
        }
        this.currentResultSet = new CassandraResultSet(this, parsedStmt, resultSet);
    }

    @Override
    protected SQLException tryClose() {
        SQLException e = null;
        try {
            if (this.currentResultSet != null && !this.currentResultSet.isClosed()) {
                this.currentResultSet.close();
            }
        }
        catch (Throwable t) {
            Logger.warn(t, "Not able to close the current result set: {}", this.currentResultSet);
            e = new SQLException(t);
        }
        finally {
            this.currentResultSet = null;
        }
        return e;
    }

    @Override
    protected Object unwrap() {
        return this.session;
    }

    @Override
    protected void validateState() throws SQLException {
        super.validateState();
        if (this.session == null || this.session.isClosed()) {
            this.session = null;
            throw CassandraErrors.statementClosedException();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        CassandraEnums.Batch mode = this.getConfiguration().getBatch();
        BatchStatement batchStmt = new BatchStatement(mode == CassandraEnums.Batch.LOGGED ? BatchStatement.Type.LOGGED : BatchStatement.Type.UNLOGGED);
        for (CassandraCqlStatement stmt : this.batch) {
            batchStmt.add(new SimpleStatement(stmt.getCql()));
        }
        this.session.execute(batchStmt);
        int[] results = new int[this.batch.size()];
        for (int i = 0; i < results.length; ++i) {
            results[i] = -2;
        }
        return results;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.validateState();
        this.executeCql(sql);
        return this.cqlStmt.getConfiguration().getStatementType().isQuery();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw CassandraErrors.notSupportedException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw CassandraErrors.notSupportedException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw CassandraErrors.notSupportedException();
    }

    @Override
    public java.sql.ResultSet executeQuery(String sql) throws SQLException {
        if (!this.execute(sql)) {
            throw CassandraErrors.invalidQueryException(sql);
        }
        return this.currentResultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.validateState();
        this.executeCql(sql);
        return this.cqlStmt.getConfiguration().getStatementType().isUpdate() ? 1 : 0;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw CassandraErrors.notSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw CassandraErrors.notSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw CassandraErrors.notSupportedException();
    }

    @Override
    public java.sql.ResultSet getResultSet() throws SQLException {
        return this.cqlStmt.getConfiguration().getStatementType().isQuery() ? this.currentResultSet : null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        CassandraStatementType stmtType = this.cqlStmt.getConfiguration().getStatementType();
        return stmtType.isQuery() ? -1 : (stmtType.isUpdate() ? 1 : 0);
    }

    @Override
    public java.sql.ResultSet executeQuery() throws SQLException {
        throw CassandraErrors.notSupportedException();
    }

    @Override
    public int executeUpdate() throws SQLException {
        throw CassandraErrors.notSupportedException();
    }

    @Override
    public boolean execute() throws SQLException {
        throw CassandraErrors.notSupportedException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw CassandraErrors.notSupportedException();
    }
}

