/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.provider.datastax;

import com.github.cassandra.jdbc.BaseCassandraResultSet;
import com.github.cassandra.jdbc.BaseCassandraStatement;
import com.github.cassandra.jdbc.CassandraColumnDefinition;
import com.github.cassandra.jdbc.CassandraCqlStatement;
import com.github.cassandra.jdbc.CassandraDataType;
import com.github.cassandra.jdbc.CassandraErrors;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ColumnDefinitions;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ResultSet;
import com.github.cassandra.jdbc.internal.datastax.driver.core.Row;
import com.github.cassandra.jdbc.internal.tinylog.Logger;
import java.sql.SQLException;

public class CassandraResultSet
extends BaseCassandraResultSet {
    private Row _currentRow;
    private ResultSet _resultSet;

    protected CassandraResultSet(BaseCassandraStatement statement, CassandraCqlStatement parsedStmt, ResultSet rs) {
        super(statement, parsedStmt);
        if (rs != null) {
            for (ColumnDefinitions.Definition def : rs.getColumnDefinitions()) {
                CassandraColumnDefinition d = new CassandraColumnDefinition(def.getKeyspace(), def.getTable(), def.getName(), def.getType().getName().toString(), false);
                this.metadata.addColumnDefinition(d);
            }
        }
        this._resultSet = rs;
    }

    @Override
    protected <T> T getValue(int columnIndex, Class<T> clazz) throws SQLException {
        T result;
        Object rawValue;
        block3: {
            Logger.trace("Trying to get value with inputs: line={}, column={}, type={}", this.getRow(), columnIndex, clazz);
            rawValue = null;
            result = null;
            if (this._currentRow != null) {
                String typeName = this.metadata.getColumnTypeName(columnIndex);
                rawValue = clazz == String.class && (CassandraDataType.TIME.getTypeName().equals(typeName) || CassandraDataType.TIMESTAMP.getTypeName().equals(typeName)) ? this._currentRow.getString(columnIndex - 1) : this._currentRow.getObject(columnIndex - 1);
                Logger.trace("Got raw value [{}] from line #{}", rawValue, this.getRow());
                this.wasNull = rawValue == null;
                try {
                    result = this.getDataTypeConverters().convert(rawValue, clazz, true);
                }
                catch (ClassCastException e) {
                    Logger.warn(e, "Not able to convert [{}] to {}", rawValue, clazz);
                    if (this.quiet) break block3;
                    throw new SQLException(e);
                }
            }
        }
        Logger.trace("Return value: raw={}, converted={}", rawValue, result);
        return result;
    }

    @Override
    protected boolean hasMore() {
        return this._resultSet != null && !this._resultSet.isExhausted();
    }

    @Override
    protected <T> void setValue(int columnIndex, T value) throws SQLException {
        throw CassandraErrors.notSupportedException();
    }

    @Override
    protected SQLException tryClose() {
        if (this._resultSet != null) {
            this._resultSet = null;
            this._currentRow = null;
        }
        return null;
    }

    @Override
    protected boolean tryIterate() throws SQLException {
        boolean result = false;
        if (this._resultSet != null) {
            try {
                this._currentRow = this._resultSet.one();
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
            result = this._currentRow != null;
        }
        return result;
    }

    @Override
    protected boolean tryMoveTo(int rows, boolean relativeIndex) throws SQLException {
        throw CassandraErrors.notSupportedException();
    }

    @Override
    protected Object unwrap() {
        return this._resultSet;
    }
}

