/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.provider.datastax;

import com.github.cassandra.jdbc.CassandraColumnDefinition;
import com.github.cassandra.jdbc.CassandraCqlParser;
import com.github.cassandra.jdbc.CassandraCqlStatement;
import com.github.cassandra.jdbc.CassandraCqlStmtConfiguration;
import com.github.cassandra.jdbc.CassandraDataType;
import com.github.cassandra.jdbc.CassandraEnums;
import com.github.cassandra.jdbc.CassandraErrors;
import com.github.cassandra.jdbc.internal.datastax.driver.core.BatchStatement;
import com.github.cassandra.jdbc.internal.datastax.driver.core.BoundStatement;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ColumnDefinitions;
import com.github.cassandra.jdbc.internal.datastax.driver.core.PreparedStatement;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ResultSet;
import com.github.cassandra.jdbc.internal.datastax.driver.core.SimpleStatement;
import com.github.cassandra.jdbc.internal.google.common.base.Objects;
import com.github.cassandra.jdbc.internal.google.common.cache.Cache;
import com.github.cassandra.jdbc.internal.google.common.cache.CacheBuilder;
import com.github.cassandra.jdbc.internal.joda.time.LocalDate;
import com.github.cassandra.jdbc.internal.joda.time.LocalTime;
import com.github.cassandra.jdbc.internal.tinylog.Logger;
import com.github.cassandra.jdbc.provider.datastax.CassandraConnection;
import com.github.cassandra.jdbc.provider.datastax.CassandraStatement;
import com.github.cassandra.jdbc.provider.datastax.DataStaxSessionWrapper;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class CassandraPreparedStatement
extends CassandraStatement {
    protected final Cache<String, PreparedStatement> preparedStmtCache = CacheBuilder.newBuilder().maximumSize(50L).build();

    protected CassandraPreparedStatement(CassandraConnection conn, DataStaxSessionWrapper session, String sql) throws SQLException {
        super(conn, session, sql);
        this.updateParameterMetaData(this.cqlStmt, true);
    }

    protected PreparedStatement getInnerPreparedStatement(final String cql) throws SQLException {
        PreparedStatement preparedStmt = null;
        try {
            preparedStmt = this.preparedStmtCache.get(cql, new Callable<PreparedStatement>(){

                @Override
                public PreparedStatement call() throws Exception {
                    return CassandraPreparedStatement.this.session.prepare(cql);
                }
            });
        }
        catch (ExecutionException e) {
            throw new SQLException(e);
        }
        return preparedStmt;
    }

    protected void updateParameterMetaData(CassandraCqlStatement cql, boolean force) throws SQLException {
        if (force || !Objects.equal(this.cqlStmt.getCql(), cql.getCql())) {
            this.cqlStmt = cql;
            PreparedStatement preparedStmt = this.getInnerPreparedStatement(cql.getCql());
            this.parameterMetaData.clear();
            for (ColumnDefinitions.Definition def : preparedStmt.getVariables().asList()) {
                this.parameterMetaData.addParameterDefinition(new CassandraColumnDefinition(def.getKeyspace(), def.getTable(), def.getName(), def.getName(), def.getType().toString(), false, false));
            }
        }
    }

    @Override
    protected void setParameter(int paramIndex, Object paramValue) throws SQLException {
        String typeName = this.parameterMetaData.getParameterTypeName(paramIndex);
        Class<?> javaClass = this.getDataTypeMappings().javaTypeFor(typeName);
        boolean replaceNullValue = this.cqlStmt.getConfiguration().replaceNullValue();
        if (javaClass != null) {
            paramValue = this.getDataTypeConverters().convert(paramValue, javaClass, replaceNullValue);
            if (CassandraDataType.TIME.getTypeName().equals(typeName) && paramValue instanceof Time) {
                Time time = (Time)paramValue;
                paramValue = (long)new LocalTime(time).getMillisOfDay() * 1000000L;
            } else if (CassandraDataType.DATE.getTypeName().equals(typeName) && paramValue instanceof Date) {
                LocalDate localDate = LocalDate.fromDateFields((Date)paramValue);
                paramValue = com.github.cassandra.jdbc.internal.datastax.driver.core.LocalDate.fromYearMonthDay(localDate.getYear(), localDate.getMonthOfYear(), localDate.getDayOfMonth());
            } else if (CassandraDataType.BLOB.getTypeName().equals(typeName) && paramValue instanceof byte[]) {
                paramValue = ByteBuffer.wrap((byte[])paramValue);
            }
            this.parameters.put(paramIndex, paramValue);
        } else {
            super.setParameter(paramIndex, paramValue);
        }
    }

    protected ResultSet executePreparedCql(String cql, Object ... params) throws SQLException {
        Logger.debug("Trying to execute the following CQL:\n{}", cql);
        CassandraCqlStatement parsedStmt = this.cqlStmt.getCql().equals(cql) ? this.cqlStmt : CassandraCqlParser.parse(this.getConfiguration(), cql);
        CassandraCqlStmtConfiguration stmtConf = parsedStmt.getConfiguration();
        Logger.debug("Statement Configuration:\n{}", stmtConf);
        this.updateParameterMetaData(CassandraCqlParser.parse(this.getConfiguration(), cql), false);
        PreparedStatement preparedStmt = this.getInnerPreparedStatement(cql);
        BoundStatement boundStatement = preparedStmt.bind(params);
        this.configureStatement(boundStatement, stmtConf);
        ResultSet rs = null;
        if (stmtConf.noWait()) {
            this.session.executeAsync(boundStatement);
        } else {
            rs = this.session.execute(boundStatement);
        }
        this.postStatementExecution(parsedStmt, rs);
        return rs;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        CassandraEnums.Batch mode = this.getConfiguration().getBatch();
        BatchStatement batchStmt = new BatchStatement(mode == CassandraEnums.Batch.LOGGED ? BatchStatement.Type.LOGGED : BatchStatement.Type.UNLOGGED);
        for (CassandraCqlStatement stmt : this.batch) {
            String cql = stmt.getCql();
            if (stmt.hasParameter()) {
                batchStmt.add(this.getInnerPreparedStatement(cql).bind(stmt.getParameters()));
                continue;
            }
            batchStmt.add(new SimpleStatement(cql));
        }
        this.session.execute(batchStmt);
        int[] results = new int[this.batch.size()];
        for (int i = 0; i < results.length; ++i) {
            results[i] = -2;
        }
        return results;
    }

    @Override
    public boolean execute() throws SQLException {
        return this.execute(this.cqlStmt.getCql());
    }

    @Override
    public java.sql.ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.cqlStmt.getCql());
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.executeUpdate(this.cqlStmt.getCql());
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.currentResultSet == null) {
            throw CassandraErrors.databaseMetaDataNotAvailableException();
        }
        return this.currentResultSet.getMetaData();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.validateState();
        Object[] params = new Object[this.parameters.size()];
        int i = 0;
        for (Map.Entry entry : this.parameters.entrySet()) {
            params[i++] = entry.getValue();
        }
        this.executePreparedCql(sql, params);
        return this.cqlStmt.getConfiguration().getStatementType().isQuery();
    }

    @Override
    public java.sql.ResultSet executeQuery(String sql) throws SQLException {
        if (!this.execute(sql)) {
            throw CassandraErrors.invalidQueryException(sql);
        }
        return this.currentResultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.execute(sql);
        return this.cqlStmt.getConfiguration().getStatementType().isUpdate() ? 1 : 0;
    }
}

