/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.provider.datastax;

import com.github.cassandra.jdbc.BaseCassandraConnection;
import com.github.cassandra.jdbc.CassandraConfiguration;
import com.github.cassandra.jdbc.CassandraErrors;
import com.github.cassandra.jdbc.CassandraObjectType;
import com.github.cassandra.jdbc.CassandraUtils;
import com.github.cassandra.jdbc.DummyCassandraResultSet;
import com.github.cassandra.jdbc.internal.datastax.driver.core.Cluster;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ColumnMetadata;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ConsistencyLevel;
import com.github.cassandra.jdbc.internal.datastax.driver.core.IndexMetadata;
import com.github.cassandra.jdbc.internal.datastax.driver.core.KeyspaceMetadata;
import com.github.cassandra.jdbc.internal.datastax.driver.core.SimpleStatement;
import com.github.cassandra.jdbc.internal.datastax.driver.core.TableMetadata;
import com.github.cassandra.jdbc.internal.datastax.driver.core.UserType;
import com.github.cassandra.jdbc.internal.google.common.base.Strings;
import com.github.cassandra.jdbc.internal.tinylog.Logger;
import com.github.cassandra.jdbc.provider.datastax.CassandraPreparedStatement;
import com.github.cassandra.jdbc.provider.datastax.CassandraStatement;
import com.github.cassandra.jdbc.provider.datastax.DataStaxDataTypes;
import com.github.cassandra.jdbc.provider.datastax.DataStaxSessionFactory;
import com.github.cassandra.jdbc.provider.datastax.DataStaxSessionWrapper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class CassandraConnection
extends BaseCassandraConnection {
    static final com.github.cassandra.jdbc.internal.datastax.driver.core.Statement CQL_TO_GET_VERSION = new SimpleStatement("select release_version from system.local where key='local' limit 1");
    static final String PROVIDER_NAME = "DataStax Java Driver";
    static final String DRIVER_NAME = "Cassandra JDBC Driver (using DataStax Java Driver)";
    private DataStaxSessionWrapper _session;
    private String _keyspace;

    public CassandraConnection(CassandraConfiguration driverConfig) {
        super(driverConfig);
        this._keyspace = driverConfig.getKeyspace();
        this._session = DataStaxSessionFactory.getSession(driverConfig);
        this.metaData.setProperty("driverName", DRIVER_NAME);
        this.metaData.setProperty("driverVersion", CassandraConfiguration.DRIVER_VERSION + ' ' + '(' + PROVIDER_NAME + ' ' + Cluster.getDriverVersion() + ')');
    }

    private ResultSet buildResultSet(String[][] columns, List<Object[]> list) {
        Object[][] data = new Object[list.size()][];
        int index = 0;
        for (Object[] objs : list) {
            data[index++] = objs;
        }
        return new DummyCassandraResultSet(columns, data);
    }

    private Object[] populateColumnMetaData(KeyspaceMetadata ks, TableMetadata t, ColumnMetadata c, int colIndex) {
        String cqlType = c.getType().toString().toLowerCase();
        boolean isKey = t.getPrimaryKey().contains(c);
        return new Object[]{null, ks.getName(), t.getName(), c.getName(), DataStaxDataTypes.mappings.sqlTypeFor(cqlType), cqlType, 0, 65535, 0, 10, isKey ? 0 : 1, "", null, 0, 0, 0, colIndex, isKey ? "NO" : "YES", null, null, null, null, "NO", "NO"};
    }

    private Object[] populateIndexMetaData(KeyspaceMetadata ks, TableMetadata t, ColumnMetadata pk, int colIndex, boolean unique) {
        return new Object[]{null, ks.getName(), t.getName(), unique, "", "PRIMARY", (short)3, colIndex, pk.getName(), null, 100, 0, null};
    }

    private Object[] populateIndexMetaData(KeyspaceMetadata ks, TableMetadata t, IndexMetadata i) {
        return new Object[]{null, ks.getName(), t.getName(), false, "", i.getName(), (short)3, 1, i.getTarget(), null, 100, 0, null};
    }

    private Object[] populatePrimaryKeyMetaData(KeyspaceMetadata ks, TableMetadata t, ColumnMetadata c, int colIndex) {
        return new Object[]{null, ks.getName(), t.getName(), c.getName(), colIndex, "PRIMARY"};
    }

    private Object[] populateTableMetaData(KeyspaceMetadata ks, TableMetadata t) {
        return new Object[]{null, ks.getName(), t.getName(), "TABLE", "ID: [" + t.getId() + "] \nDDL: \n" + t.exportAsString(), null, null, null, null, "USER"};
    }

    private Object[] populateUdtMetaData(KeyspaceMetadata ks, UserType t) {
        return new Object[]{null, ks.getName(), t.getTypeName(), t.getTypeArguments(), 2000, t.getName().toString(), null};
    }

    @Override
    protected <T> T createObject(Class<T> clazz) throws SQLException {
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
        return null;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    protected ResultSet getObjectMetaData(CassandraObjectType objectType, Properties queryPatterns, Object ... additionalHints) throws SQLException {
        Logger.trace("Trying to get meta data with the following parameters:\nobjectType: {}\nqueryPatterns:\n{}\nadditionalHints: {}", new Object[]{objectType.name(), queryPatterns, additionalHints});
        rs = new DummyCassandraResultSet();
        m = this._session.getClusterMetaData();
        switch (1.$SwitchMap$com$github$cassandra$jdbc$CassandraObjectType[objectType.ordinal()]) {
            case 1: {
                keyspaces = m.getKeyspaces();
                data = new String[keyspaces.size()][1];
                index = 0;
                for (KeyspaceMetadata km : keyspaces) {
                    data[index++][0] = km.getName();
                }
                rs = new DummyCassandraResultSet(CassandraUtils.SCHEMA_COLUMNS, data);
                break;
            }
            case 2: {
                schemaPattern = CassandraUtils.getPropertyValue(queryPatterns, "schemaPattern");
                tablePattern = CassandraUtils.getPropertyValue(queryPatterns, "tableNamePattern");
                queryTable = false;
                if (additionalHints == null) ** GOTO lbl24
                for (Iterator<TableMetadata> type : additionalHints) {
                    if (!CassandraObjectType.TABLE.toString().equals(type)) continue;
                    queryTable = true;
                    ** GOTO lbl25
                }
                ** GOTO lbl25
lbl24:
                // 1 sources

                queryTable = true;
lbl25:
                // 3 sources

                list = new ArrayList<Object[]>();
                if (queryTable) {
                    for (KeyspaceMetadata ks : m.getKeyspaces()) {
                        if (!CassandraUtils.matchesPattern(ks.getName(), schemaPattern)) continue;
                        for (TableMetadata t : ks.getTables()) {
                            if (!CassandraUtils.matchesPattern(t.getName(), tablePattern)) continue;
                            list.add(this.populateTableMetaData(ks, t));
                        }
                    }
                }
                rs = this.buildResultSet(CassandraUtils.TABLE_COLUMNS, list);
                break;
            }
            case 3: {
                schemaPattern = CassandraUtils.getPropertyValue(queryPatterns, "schemaPattern");
                tablePattern = CassandraUtils.getPropertyValue(queryPatterns, "tableNamePattern");
                columnPattern = CassandraUtils.getPropertyValue(queryPatterns, "columnNamePattern");
                list = new ArrayList<Object[]>();
                for (KeyspaceMetadata ks : m.getKeyspaces()) {
                    if (!CassandraUtils.matchesPattern(ks.getName(), schemaPattern)) continue;
                    for (TableMetadata t : ks.getTables()) {
                        if (!CassandraUtils.matchesPattern(t.getName(), tablePattern)) continue;
                        colIndex = 0;
                        for (ColumnMetadata c : t.getColumns()) {
                            ++colIndex;
                            if (CassandraUtils.isNullOrEmptyString(c.getName()) || !CassandraUtils.matchesPattern(c.getName(), columnPattern)) continue;
                            list.add(this.populateColumnMetaData(ks, t, c, colIndex));
                        }
                    }
                }
                rs = this.buildResultSet(CassandraUtils.COLUMN_COLUMNS, list);
                break;
            }
            case 4: {
                schemaPattern = CassandraUtils.getPropertyValue(queryPatterns, "schemaPattern");
                tablePattern = CassandraUtils.getPropertyValue(queryPatterns, "tableNamePattern");
                uniqueIndexOnly = Boolean.valueOf(CassandraUtils.getPropertyValue(queryPatterns, "uniqueIndexOnly", Boolean.FALSE.toString()));
                list = new ArrayList<Object[]>();
                for (KeyspaceMetadata ks : m.getKeyspaces()) {
                    if (!CassandraUtils.matchesPattern(ks.getName(), schemaPattern)) continue;
                    for (TableMetadata t : ks.getTables()) {
                        if (!CassandraUtils.matchesPattern(t.getName(), tablePattern)) continue;
                        colIndex = 0;
                        primaryKeys = t.getPrimaryKey();
                        v0 = uniquePk = primaryKeys.size() == 1;
                        if (!uniqueIndexOnly || uniquePk) {
                            for (ColumnMetadata c : primaryKeys) {
                                list.add(this.populateIndexMetaData(ks, t, c, ++colIndex, uniquePk));
                            }
                        }
                        for (IndexMetadata i : t.getIndexes()) {
                            if (i == null || i.getKind() == IndexMetadata.Kind.KEYS) continue;
                            list.add(this.populateIndexMetaData(ks, t, i));
                        }
                    }
                }
                rs = this.buildResultSet(CassandraUtils.INDEX_COLUMNS, list);
                break;
            }
            case 5: {
                schemaPattern = CassandraUtils.getPropertyValue(queryPatterns, "schemaPattern");
                tablePattern = CassandraUtils.getPropertyValue(queryPatterns, "tableNamePattern");
                list = new ArrayList<Object[]>();
                for (KeyspaceMetadata ks : m.getKeyspaces()) {
                    if (!CassandraUtils.matchesPattern(ks.getName(), schemaPattern)) continue;
                    for (TableMetadata t : ks.getTables()) {
                        if (!CassandraUtils.matchesPattern(t.getName(), tablePattern)) continue;
                        colIndex = 0;
                        for (ColumnMetadata c : t.getPrimaryKey()) {
                            list.add(this.populatePrimaryKeyMetaData(ks, t, c, ++colIndex));
                        }
                    }
                }
                rs = this.buildResultSet(CassandraUtils.PK_COLUMNS, list);
                break;
            }
            case 6: {
                schemaPattern = CassandraUtils.getPropertyValue(queryPatterns, "schemaPattern");
                typePattern = CassandraUtils.getPropertyValue(queryPatterns, "typeNamePattern");
                list = new ArrayList<Object[]>();
                for (KeyspaceMetadata ks : m.getKeyspaces()) {
                    if (!CassandraUtils.matchesPattern(ks.getName(), schemaPattern)) continue;
                    for (UserType t : ks.getUserTypes()) {
                        if (!CassandraUtils.matchesPattern(t.getTypeName(), typePattern)) continue;
                        list.add(this.populateUdtMetaData(ks, t));
                    }
                }
                rs = this.buildResultSet(CassandraUtils.UDT_COLUMNS, list);
                break;
            }
            default: {
                rs = super.getObjectMetaData(objectType, queryPatterns, additionalHints);
            }
        }
        rowCount = 0;
        colCount = 0;
        if (rs instanceof DummyCassandraResultSet) {
            drs = rs;
            rowCount = drs.getRowCount();
            colCount = drs.getColumnCount();
        }
        Logger.trace("Returning results with {} x {}  two-dimensional array", new Object[]{rowCount, colCount});
        return rs;
    }

    @Override
    protected SQLException tryClose() {
        SQLException e = CassandraUtils.tryClose(this._session);
        this._session = null;
        return e;
    }

    @Override
    protected Object unwrap() {
        return this._session;
    }

    @Override
    protected void validateState() throws SQLException {
        super.validateState();
        if (this._session == null || this._session.isClosed()) {
            this._session = null;
            throw CassandraErrors.connectionClosedException();
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validateState();
        return new CassandraStatement(this, this._session);
    }

    @Override
    public String getSchema() throws SQLException {
        this.validateState();
        return this._keyspace;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validateState();
        return new CassandraPreparedStatement(this, this._session, sql);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
        if (Strings.isNullOrEmpty(schema) || schema.equals(this._keyspace)) {
            return;
        }
        try {
            this._session = DataStaxSessionFactory.getSession(this.getConfiguration(), schema);
            Logger.debug("Current keyspace changed from \"" + this._keyspace + "\" to \"" + schema + "\" successfully");
            this._keyspace = schema;
        }
        catch (Exception e) {
            throw CassandraErrors.failedToChangeKeyspaceException(schema, e);
        }
    }

    static {
        CQL_TO_GET_VERSION.setConsistencyLevel(ConsistencyLevel.LOCAL_ONE);
    }
}

