/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.tinylog.writers;

import com.github.cassandra.jdbc.internal.tinylog.InternalLogger;
import com.github.cassandra.jdbc.internal.tinylog.writers.Writer;
import java.util.ArrayList;
import java.util.Collection;

public final class VMShutdownHook
extends Thread {
    private static final ShutdownThread shutdownThread = new ShutdownThread();
    private static final Collection<Writer> writers = new ArrayList<Writer>();
    private static boolean shutdown = false;

    private VMShutdownHook() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Writer writer) {
        Collection<Writer> collection = writers;
        synchronized (collection) {
            if (!shutdown) {
                if (writers.isEmpty()) {
                    Runtime.getRuntime().addShutdownHook(shutdownThread);
                }
                writers.add(writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(Writer writer) {
        Collection<Writer> collection = writers;
        synchronized (collection) {
            if (!shutdown) {
                writers.remove(writer);
                if (writers.isEmpty()) {
                    Runtime.getRuntime().removeShutdownHook(shutdownThread);
                }
            }
        }
    }

    private static final class ShutdownThread
    extends Thread {
        private ShutdownThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Collection collection = writers;
            synchronized (collection) {
                shutdown = true;
                for (Writer writer : writers) {
                    try {
                        writer.close();
                    }
                    catch (Exception exception) {
                        InternalLogger.error(exception, "Failed to shutdown writer");
                    }
                }
                writers.clear();
                shutdown = false;
            }
        }
    }
}

