/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.tinylog.writers;

import com.github.cassandra.jdbc.internal.tinylog.Configuration;
import com.github.cassandra.jdbc.internal.tinylog.EnvironmentHelper;
import com.github.cassandra.jdbc.internal.tinylog.LogEntry;
import com.github.cassandra.jdbc.internal.tinylog.labelers.CountLabeler;
import com.github.cassandra.jdbc.internal.tinylog.labelers.Labeler;
import com.github.cassandra.jdbc.internal.tinylog.policies.Policy;
import com.github.cassandra.jdbc.internal.tinylog.policies.StartupPolicy;
import com.github.cassandra.jdbc.internal.tinylog.writers.LogEntryValue;
import com.github.cassandra.jdbc.internal.tinylog.writers.PropertiesSupport;
import com.github.cassandra.jdbc.internal.tinylog.writers.Property;
import com.github.cassandra.jdbc.internal.tinylog.writers.VMShutdownHook;
import com.github.cassandra.jdbc.internal.tinylog.writers.Writer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PropertiesSupport(name="rollingfile", properties={@Property(name="filename", type=String.class), @Property(name="backups", type=int.class), @Property(name="buffered", type=boolean.class, optional=true), @Property(name="label", type=Labeler.class, optional=true), @Property(name="policies", type=Policy[].class, optional=true)})
public final class RollingFileWriter
implements Writer {
    private static final int BUFFER_SIZE = 65536;
    private final String filename;
    private final int backups;
    private final boolean buffered;
    private final Labeler labeler;
    private final List<? extends Policy> policies;
    private final Object mutex = new Object();
    private File file;
    private OutputStream stream;

    public RollingFileWriter(String string, int n) {
        this(string, n, false, (Labeler)null, (Policy[])null);
    }

    public RollingFileWriter(String string, int n, boolean bl) {
        this(string, n, bl, (Labeler)null, (Policy[])null);
    }

    public RollingFileWriter(String string, int n, Labeler labeler) {
        this(string, n, false, labeler, (Policy[])null);
    }

    public RollingFileWriter(String string, int n, boolean bl, Labeler labeler) {
        this(string, n, bl, labeler, (Policy[])null);
    }

    public RollingFileWriter(String string, int n, Policy ... policyArray) {
        this(string, n, false, (Labeler)null, policyArray);
    }

    public RollingFileWriter(String string, int n, boolean bl, Policy ... policyArray) {
        this(string, n, bl, (Labeler)null, policyArray);
    }

    public RollingFileWriter(String string, int n, Labeler labeler, Policy ... policyArray) {
        this(string, n, false, labeler, policyArray);
    }

    public RollingFileWriter(String string, int n, boolean bl, Labeler labeler, Policy ... policyArray) {
        this.filename = string;
        this.backups = Math.max(0, n);
        this.buffered = bl;
        this.labeler = labeler == null ? new CountLabeler() : labeler;
        this.policies = policyArray == null || policyArray.length == 0 ? Arrays.asList(new StartupPolicy()) : Arrays.asList(policyArray);
    }

    @Override
    public Set<LogEntryValue> getRequiredLogEntryValues() {
        return EnumSet.of(LogEntryValue.RENDERED_LOG_ENTRY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilename() {
        Object object = this.mutex;
        synchronized (object) {
            return this.file == null ? this.filename : this.file.getAbsolutePath();
        }
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public int getNumberOfBackups() {
        return this.backups;
    }

    public Labeler getLabeler() {
        return this.labeler;
    }

    public List<? extends Policy> getPolicies() {
        return Collections.unmodifiableList(this.policies);
    }

    @Override
    public void init(Configuration configuration) throws IOException {
        File file = new File(this.filename);
        EnvironmentHelper.makeDirectories(file);
        this.labeler.init(configuration);
        this.file = this.labeler.getLogFile(file);
        for (Policy policy : this.policies) {
            policy.init(configuration);
        }
        for (Policy policy : this.policies) {
            if (policy.check(this.file)) continue;
            this.resetPolicies();
            this.file = this.labeler.roll(this.file, this.backups);
            break;
        }
        this.stream = this.buffered ? new BufferedOutputStream(new FileOutputStream(this.file, true), 65536) : new FileOutputStream(this.file, true);
        VMShutdownHook.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(LogEntry logEntry) throws IOException {
        String string = logEntry.getRenderedLogEntry();
        byte[] byArray = string.getBytes();
        Object object = this.mutex;
        synchronized (object) {
            if (!this.checkPolicies(string)) {
                this.stream.close();
                this.file = this.labeler.roll(this.file, this.backups);
                this.stream = this.buffered ? new BufferedOutputStream(new FileOutputStream(this.file), 65536) : new FileOutputStream(this.file);
            }
            this.stream.write(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        if (this.buffered) {
            Object object = this.mutex;
            synchronized (object) {
                this.stream.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            VMShutdownHook.unregister(this);
            this.stream.close();
        }
    }

    private boolean checkPolicies(String string) {
        for (Policy policy : this.policies) {
            if (policy.check(string)) continue;
            this.resetPolicies();
            return false;
        }
        return true;
    }

    private void resetPolicies() {
        for (Policy policy : this.policies) {
            policy.reset();
        }
    }
}

