/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.tinylog.writers;

import com.github.cassandra.jdbc.internal.tinylog.Configuration;
import com.github.cassandra.jdbc.internal.tinylog.Level;
import com.github.cassandra.jdbc.internal.tinylog.LogEntry;
import com.github.cassandra.jdbc.internal.tinylog.writers.LogEntryValue;
import com.github.cassandra.jdbc.internal.tinylog.writers.PropertiesSupport;
import com.github.cassandra.jdbc.internal.tinylog.writers.Writer;
import java.io.PrintStream;
import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PropertiesSupport(name="console", properties={})
public final class ConsoleWriter
implements Writer {
    @Override
    public Set<LogEntryValue> getRequiredLogEntryValues() {
        return EnumSet.of(LogEntryValue.LEVEL, LogEntryValue.RENDERED_LOG_ENTRY);
    }

    @Override
    public void init(Configuration configuration) {
    }

    @Override
    public void write(LogEntry logEntry) {
        ConsoleWriter.getPrintStream(logEntry.getLevel()).print(logEntry.getRenderedLogEntry());
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    private static PrintStream getPrintStream(Level level) {
        if (level == Level.ERROR || level == Level.WARNING) {
            return System.err;
        }
        return System.out;
    }
}

