/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.tinylog.policies;

import com.github.cassandra.jdbc.internal.tinylog.policies.AbstractTimeBasedPolicy;
import com.github.cassandra.jdbc.internal.tinylog.policies.PropertiesSupport;
import java.util.Calendar;
import java.util.regex.Pattern;

@PropertiesSupport(name="weekly")
public final class WeeklyPolicy
extends AbstractTimeBasedPolicy {
    private static final Pattern DAY_OF_WEEK_PATTERN = Pattern.compile("[1234567]");

    public WeeklyPolicy() {
        super(WeeklyPolicy.createCalendar(1), 3);
    }

    public WeeklyPolicy(int n) throws IllegalArgumentException {
        super(WeeklyPolicy.createCalendar(n), 3);
    }

    WeeklyPolicy(String string) throws IllegalArgumentException {
        super(WeeklyPolicy.createCalendar(string), 3);
    }

    private static Calendar createCalendar(int n) {
        if (n < 1 || n > 7) {
            throw new IllegalArgumentException("dayOfWeek must be between 1..7");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(7, WeeklyPolicy.convert(calendar, n));
        WeeklyPolicy.normalize(calendar, 3);
        return calendar;
    }

    private static int convert(Calendar calendar, int n) {
        return (calendar.getFirstDayOfWeek() - 1 + n - 1) % 7 + 1;
    }

    private static Calendar createCalendar(String string) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(7, WeeklyPolicy.convert(calendar, string));
        WeeklyPolicy.normalize(calendar, 3);
        return calendar;
    }

    private static int convert(Calendar calendar, String string) {
        if ("Monday".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("Tuesday".equalsIgnoreCase(string)) {
            return 3;
        }
        if ("Wednesday".equalsIgnoreCase(string)) {
            return 4;
        }
        if ("Thursday".equalsIgnoreCase(string)) {
            return 5;
        }
        if ("Friday".equalsIgnoreCase(string)) {
            return 6;
        }
        if ("Saturday".equalsIgnoreCase(string)) {
            return 7;
        }
        if ("Sunday".equalsIgnoreCase(string)) {
            return 1;
        }
        if (DAY_OF_WEEK_PATTERN.matcher(string).matches()) {
            return WeeklyPolicy.convert(calendar, Integer.parseInt(string));
        }
        throw new IllegalArgumentException("Unknown day");
    }
}

