/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.tinylog.policies;

import com.github.cassandra.jdbc.internal.tinylog.Configuration;
import com.github.cassandra.jdbc.internal.tinylog.policies.Policy;
import com.github.cassandra.jdbc.internal.tinylog.policies.PropertiesSupport;
import java.io.File;

@PropertiesSupport(name="size")
public final class SizePolicy
implements Policy {
    private final long maxSize;
    private long size;

    public SizePolicy(long l) throws IllegalArgumentException {
        if (l <= 0L) {
            throw new IllegalArgumentException("maxSize must be > 0");
        }
        this.maxSize = l;
        this.size = 0L;
    }

    SizePolicy(String string) throws IllegalArgumentException {
        try {
            this.maxSize = string.endsWith("GB") ? Long.parseLong(string.substring(0, string.length() - 2).trim()) * 1024L * 1024L * 1024L : (string.endsWith("MB") ? Long.parseLong(string.substring(0, string.length() - 2).trim()) * 1024L * 1024L : (string.endsWith("KB") ? Long.parseLong(string.substring(0, string.length() - 2).trim()) * 1024L : Long.parseLong(string)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Size \"" + string + "\" is not numberic");
        }
        if (this.maxSize <= 0L) {
            throw new IllegalArgumentException("Size must be > 0, but is " + this.maxSize);
        }
        this.size = 0L;
    }

    public void init(Configuration configuration) {
    }

    public boolean check(File file) {
        if (file.exists()) {
            this.size = file.length();
            return this.size <= this.maxSize;
        }
        return true;
    }

    public boolean check(String string) {
        this.size += (long)string.getBytes().length;
        return this.size <= this.maxSize;
    }

    public void reset() {
        this.size = 0L;
    }
}

