/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.tinylog.policies;

import com.github.cassandra.jdbc.internal.tinylog.policies.AbstractTimeBasedPolicy;
import com.github.cassandra.jdbc.internal.tinylog.policies.PropertiesSupport;
import java.util.Calendar;
import java.util.regex.Pattern;

@PropertiesSupport(name="daily")
public final class DailyPolicy
extends AbstractTimeBasedPolicy {
    public DailyPolicy() {
        super(DailyPolicy.createCalendar(0, 0), 5);
    }

    public DailyPolicy(int n, int n2) throws IllegalArgumentException {
        super(DailyPolicy.createCalendar(n % 24, n2), 5);
    }

    DailyPolicy(String string) throws IllegalArgumentException {
        this(DailyPolicy.parseHour(string), DailyPolicy.parseMinute(string));
    }

    private static Calendar createCalendar(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("hour must be between 0..23");
        }
        if (n2 < 0 || n2 >= 60) {
            throw new IllegalArgumentException("minute must be between 0..59");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, 0);
        calendar.set(14, 0);
        DailyPolicy.normalize(calendar, 5);
        return calendar;
    }

    private static int parseHour(String string) {
        String[] stringArray = string.split(Pattern.quote(":"));
        try {
            return Integer.parseInt(stringArray[0].trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid time");
        }
    }

    private static int parseMinute(String string) {
        String[] stringArray = string.split(Pattern.quote(":"));
        if (stringArray.length >= 2) {
            try {
                return Integer.parseInt(stringArray[1].trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Invalid time");
            }
        }
        return 0;
    }
}

