/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.tinylog.policies;

import com.github.cassandra.jdbc.internal.tinylog.Configuration;
import com.github.cassandra.jdbc.internal.tinylog.policies.Policy;
import com.github.cassandra.jdbc.internal.tinylog.policies.PropertiesSupport;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@PropertiesSupport(name="count")
public final class CountPolicy
implements Policy {
    private static final Pattern NEW_LINE_PATTERN = Pattern.compile("\r\n|\\\\r\\\\n|\n|\\\\n|\r|\\\\r");
    private final long limit;
    private long lines;
    private long count;

    public CountPolicy(long l) throws IllegalArgumentException {
        if (l <= 0L) {
            throw new IllegalArgumentException("limit must be > 0");
        }
        this.limit = l;
        this.count = 0L;
    }

    CountPolicy(String string) throws IllegalArgumentException {
        try {
            this.limit = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Size \"" + string + "\" is not numberic");
        }
        if (this.limit <= 0L) {
            throw new IllegalArgumentException("Size must be > 0, but is " + this.limit);
        }
        this.count = 0L;
    }

    public void init(Configuration configuration) {
        String string = configuration.getFormatPattern();
        Matcher matcher = NEW_LINE_PATTERN.matcher(string);
        this.lines = 1L;
        while (matcher.find()) {
            ++this.lines;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check(File file) throws IOException {
        if (file.exists()) {
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
            try {
                lineNumberReader.skip(Long.MAX_VALUE);
                this.count = (long)lineNumberReader.getLineNumber() / this.lines;
                boolean bl = this.count <= this.limit;
                return bl;
            }
            finally {
                lineNumberReader.close();
            }
        }
        return true;
    }

    public boolean check(String string) {
        ++this.count;
        return this.count <= this.limit;
    }

    public void reset() {
        this.count = 0L;
    }
}

