/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.tinylog.labelers;

import com.github.cassandra.jdbc.internal.tinylog.Configuration;
import com.github.cassandra.jdbc.internal.tinylog.InternalLogger;
import com.github.cassandra.jdbc.internal.tinylog.labelers.Labeler;
import com.github.cassandra.jdbc.internal.tinylog.labelers.LogFileComparator;
import com.github.cassandra.jdbc.internal.tinylog.labelers.LogFileFilter;
import com.github.cassandra.jdbc.internal.tinylog.labelers.PropertiesSupport;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

@PropertiesSupport(name="timestamp")
public final class TimestampLabeler
implements Labeler {
    private static final String DEFAULT_TIMESTAMP_FORMAT = "yyyy-MM-dd HH-mm-ss";
    private final String timestampFormat;
    private DateFormat dateFormat;
    private LogFileFilter logFileFilter;
    private String directory;
    private String filenameWithoutExtension;
    private String filenameExtension;

    public TimestampLabeler() {
        this(DEFAULT_TIMESTAMP_FORMAT);
    }

    public TimestampLabeler(String string) {
        this.timestampFormat = string;
    }

    public void init(Configuration configuration) {
        this.dateFormat = new SimpleDateFormat(this.timestampFormat, configuration.getLocale());
    }

    public File getLogFile(File file) {
        this.directory = file.getAbsoluteFile().getParent();
        String string = file.getName();
        int n = string.indexOf(46, 1);
        if (n > 0) {
            this.filenameWithoutExtension = string.substring(0, n);
            this.filenameExtension = string.substring(n);
        } else {
            this.filenameWithoutExtension = string;
            this.filenameExtension = "";
        }
        this.logFileFilter = new LogFileFilter(this.filenameWithoutExtension, this.filenameExtension);
        return this.createFile();
    }

    public File roll(File file, int n) {
        File[] fileArray = file.getAbsoluteFile().getParentFile().listFiles(this.logFileFilter);
        if (fileArray != null && fileArray.length > n) {
            Arrays.sort(fileArray, LogFileComparator.getInstance());
            for (int i = n; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.delete()) continue;
                InternalLogger.warn("Failed to delete \"{}\"", file2);
            }
        }
        return this.createFile();
    }

    private File createFile() {
        return new File(this.directory, this.filenameWithoutExtension + "." + this.dateFormat.format(new Date()) + this.filenameExtension);
    }
}

