/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.tinylog.labelers;

import com.github.cassandra.jdbc.internal.tinylog.Configuration;
import com.github.cassandra.jdbc.internal.tinylog.EnvironmentHelper;
import com.github.cassandra.jdbc.internal.tinylog.InternalLogger;
import com.github.cassandra.jdbc.internal.tinylog.labelers.Labeler;
import com.github.cassandra.jdbc.internal.tinylog.labelers.LogFileComparator;
import com.github.cassandra.jdbc.internal.tinylog.labelers.LogFileFilter;
import com.github.cassandra.jdbc.internal.tinylog.labelers.PropertiesSupport;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

@PropertiesSupport(name="pid")
public final class ProcessIdLabeler
implements Labeler {
    private final String pid = EnvironmentHelper.getProcessId().toString();
    private LogFileFilter logFileFilter;

    public String getProcessId() {
        return this.pid;
    }

    public void init(Configuration configuration) {
    }

    public File getLogFile(File file) {
        String string = file.getAbsoluteFile().getParent();
        String string2 = file.getName();
        int n = string2.indexOf(46, 1);
        if (n > 0) {
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n);
            this.logFileFilter = new LogFileFilter(string3, string4);
            return new File(string, string3 + "." + this.pid + string4);
        }
        this.logFileFilter = new LogFileFilter(string2, "");
        return new File(string, string2 + "." + this.pid);
    }

    public File roll(File file, int n) throws IOException {
        File[] fileArray;
        if (file.exists() && !file.delete()) {
            InternalLogger.warn("Failed to delete \"{}\"", file);
        }
        if ((fileArray = file.getAbsoluteFile().getParentFile().listFiles(this.logFileFilter)) != null && fileArray.length > n) {
            Arrays.sort(fileArray, LogFileComparator.getInstance());
            for (int i = n; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.delete()) continue;
                InternalLogger.warn("Failed to delete \"{}\"", file2);
            }
        }
        return file;
    }
}

