/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.tinylog;

import com.github.cassandra.jdbc.internal.tinylog.Configuration;
import com.github.cassandra.jdbc.internal.tinylog.Configurator;
import com.github.cassandra.jdbc.internal.tinylog.EnvironmentHelper;
import com.github.cassandra.jdbc.internal.tinylog.InternalLogger;
import com.github.cassandra.jdbc.internal.tinylog.Level;
import com.github.cassandra.jdbc.internal.tinylog.LogEntry;
import com.github.cassandra.jdbc.internal.tinylog.LoggingContext;
import com.github.cassandra.jdbc.internal.tinylog.MessageFormatter;
import com.github.cassandra.jdbc.internal.tinylog.StackTraceInformation;
import com.github.cassandra.jdbc.internal.tinylog.Token;
import com.github.cassandra.jdbc.internal.tinylog.writers.LogEntryValue;
import com.github.cassandra.jdbc.internal.tinylog.writers.Writer;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sun.reflect.Reflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Logger {
    static final int DEEP_OF_STACK_TRACE = 3;
    private static final String NEW_LINE;
    private static volatile Configuration configuration;
    private static Method stackTraceMethod;
    private static boolean hasSunReflection;

    private Logger() {
    }

    public static Level getLevel() {
        return configuration.getLevel();
    }

    public static Level getLevel(Package package_) {
        return configuration.getLevel(package_.getName());
    }

    public static Level getLevel(Class<?> clazz) {
        return configuration.getLevel(clazz.getName());
    }

    public static Level getLevel(String string) {
        return configuration.getLevel(string);
    }

    public static void trace(Object object) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.TRACE)) {
            Logger.output(configuration, 3, Level.TRACE, null, object, null);
        }
    }

    public static void trace(String string) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.TRACE)) {
            Logger.output(configuration, 3, Level.TRACE, null, (Object)string, null);
        }
    }

    public static void trace(String string, Object ... objectArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.TRACE)) {
            Logger.output(configuration, 3, Level.TRACE, null, (Object)string, objectArray);
        }
    }

    public static void trace(Throwable throwable, String string, Object ... objectArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.TRACE)) {
            Logger.output(configuration, 3, Level.TRACE, throwable, (Object)string, objectArray);
        }
    }

    public static void trace(Throwable throwable) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.TRACE)) {
            Logger.output(configuration, 3, Level.TRACE, throwable, null, null);
        }
    }

    public static void debug(Object object) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.DEBUG)) {
            Logger.output(configuration, 3, Level.DEBUG, null, object, null);
        }
    }

    public static void debug(String string) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.DEBUG)) {
            Logger.output(configuration, 3, Level.DEBUG, null, (Object)string, null);
        }
    }

    public static void debug(String string, Object ... objectArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.DEBUG)) {
            Logger.output(configuration, 3, Level.DEBUG, null, (Object)string, objectArray);
        }
    }

    public static void debug(Throwable throwable, String string, Object ... objectArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.DEBUG)) {
            Logger.output(configuration, 3, Level.DEBUG, throwable, (Object)string, objectArray);
        }
    }

    public static void debug(Throwable throwable) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.DEBUG)) {
            Logger.output(configuration, 3, Level.DEBUG, throwable, null, null);
        }
    }

    public static void info(Object object) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.INFO)) {
            Logger.output(configuration, 3, Level.INFO, null, object, null);
        }
    }

    public static void info(String string) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.INFO)) {
            Logger.output(configuration, 3, Level.INFO, null, (Object)string, null);
        }
    }

    public static void info(String string, Object ... objectArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.INFO)) {
            Logger.output(configuration, 3, Level.INFO, null, (Object)string, objectArray);
        }
    }

    public static void info(Throwable throwable, String string, Object ... objectArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.INFO)) {
            Logger.output(configuration, 3, Level.INFO, throwable, (Object)string, objectArray);
        }
    }

    public static void info(Throwable throwable) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.INFO)) {
            Logger.output(configuration, 3, Level.INFO, throwable, null, null);
        }
    }

    public static void warn(Object object) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.WARNING)) {
            Logger.output(configuration, 3, Level.WARNING, null, object, null);
        }
    }

    public static void warn(String string) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.WARNING)) {
            Logger.output(configuration, 3, Level.WARNING, null, (Object)string, null);
        }
    }

    public static void warn(String string, Object ... objectArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.WARNING)) {
            Logger.output(configuration, 3, Level.WARNING, null, (Object)string, objectArray);
        }
    }

    public static void warn(Throwable throwable, String string, Object ... objectArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.WARNING)) {
            Logger.output(configuration, 3, Level.WARNING, throwable, (Object)string, objectArray);
        }
    }

    public static void warn(Throwable throwable) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.WARNING)) {
            Logger.output(configuration, 3, Level.WARNING, throwable, null, null);
        }
    }

    public static void error(Object object) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.ERROR)) {
            Logger.output(configuration, 3, Level.ERROR, null, object, null);
        }
    }

    public static void error(String string) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.ERROR)) {
            Logger.output(configuration, 3, Level.ERROR, null, (Object)string, null);
        }
    }

    public static void error(String string, Object ... objectArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.ERROR)) {
            Logger.output(configuration, 3, Level.ERROR, null, (Object)string, objectArray);
        }
    }

    public static void error(Throwable throwable, String string, Object ... objectArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.ERROR)) {
            Logger.output(configuration, 3, Level.ERROR, throwable, (Object)string, objectArray);
        }
    }

    public static void error(Throwable throwable) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(Level.ERROR)) {
            Logger.output(configuration, 3, Level.ERROR, throwable, null, null);
        }
    }

    public static Configurator getConfiguration() {
        return configuration.getConfigurator();
    }

    static void setConfiguration(Configuration configuration) throws Exception {
        Configuration configuration2 = Logger.configuration;
        if (configuration2 == null) {
            for (Writer writer : configuration.getWriters()) {
                writer.init(configuration);
            }
        } else {
            List<Writer> list = configuration.getWriters();
            List<Writer> list2 = configuration2.getWriters();
            for (Writer writer : list) {
                if (list2.contains(writer)) continue;
                writer.init(configuration);
            }
        }
        Logger.configuration = configuration;
    }

    static void output(int n, Level level, Throwable throwable, Object object, Object[] objectArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(level)) {
            Logger.output(configuration, n, level, throwable, object, objectArray);
        }
    }

    static void output(StackTraceElement stackTraceElement, Level level, Throwable throwable, Object object, Object[] objectArray) {
        Configuration configuration = Logger.configuration;
        if (configuration.isOutputPossible(level)) {
            Logger.output(configuration, stackTraceElement, level, throwable, object, objectArray);
        }
    }

    private static void output(Configuration configuration, int n, Level level, Throwable throwable, Object object, Object[] objectArray) {
        StackTraceElement stackTraceElement = null;
        Level level2 = configuration.getLevel();
        if (configuration.hasCustomLevels()) {
            boolean bl = configuration.getRequiredStackTraceInformation(level) == StackTraceInformation.CLASS_NAME;
            stackTraceElement = Logger.getStackTraceElement(n, bl);
            level2 = configuration.getLevel(stackTraceElement.getClassName());
        }
        if (level2.ordinal() <= level.ordinal()) {
            try {
                Writer[] writerArray = configuration.getEffectiveWriters(level);
                LogEntry[] logEntryArray = Logger.createLogEntries(configuration, n + 1, level, stackTraceElement, throwable, object, objectArray);
                if (configuration.getWritingThread() == null) {
                    for (int i = 0; i < writerArray.length; ++i) {
                        try {
                            writerArray[i].write(logEntryArray[i]);
                            continue;
                        }
                        catch (Exception exception) {
                            InternalLogger.error(exception, "Failed to write log entry");
                        }
                    }
                } else {
                    for (int i = 0; i < writerArray.length; ++i) {
                        configuration.getWritingThread().putLogEntry(writerArray[i], logEntryArray[i]);
                    }
                }
            }
            catch (Exception exception) {
                InternalLogger.error(exception, "Failed to create log entry");
            }
        }
    }

    private static void output(Configuration configuration, StackTraceElement stackTraceElement, Level level, Throwable throwable, Object object, Object[] objectArray) {
        Level level2 = configuration.getLevel();
        if (configuration.hasCustomLevels()) {
            level2 = configuration.getLevel(stackTraceElement.getClassName());
        }
        if (level2.ordinal() <= level.ordinal()) {
            try {
                Writer[] writerArray = configuration.getEffectiveWriters(level);
                LogEntry[] logEntryArray = Logger.createLogEntries(configuration, -1, level, stackTraceElement, throwable, object, objectArray);
                if (configuration.getWritingThread() == null) {
                    for (int i = 0; i < writerArray.length; ++i) {
                        try {
                            writerArray[i].write(logEntryArray[i]);
                            continue;
                        }
                        catch (Exception exception) {
                            InternalLogger.error(exception, "Failed to write log entry");
                        }
                    }
                } else {
                    for (int i = 0; i < writerArray.length; ++i) {
                        configuration.getWritingThread().putLogEntry(writerArray[i], logEntryArray[i]);
                    }
                }
            }
            catch (Exception exception) {
                InternalLogger.error(exception, "Failed to create log entry");
            }
        }
    }

    private static LogEntry[] createLogEntries(Configuration configuration, int n, Level level, StackTraceElement stackTraceElement, Throwable throwable, Object object, Object[] objectArray) {
        Set<LogEntryValue> set = configuration.getRequiredLogEntryValues(level);
        List<Token>[] listArray = configuration.getEffectiveFormatTokens(level);
        LogEntry[] logEntryArray = new LogEntry[listArray.length];
        Date date = null;
        String string = null;
        Thread thread = null;
        Map<String, String> map = null;
        StackTraceElement stackTraceElement2 = stackTraceElement;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n2 = -1;
        String string5 = null;
        block11: for (LogEntryValue object2 : set) {
            block0 : switch (object2) {
                case DATE: {
                    date = new Date();
                    break;
                }
                case PROCESS_ID: {
                    string = EnvironmentHelper.getProcessId().toString();
                    break;
                }
                case THREAD: {
                    thread = Thread.currentThread();
                    break;
                }
                case CONTEXT: {
                    map = LoggingContext.getMapping();
                    break;
                }
                case CLASS: {
                    int list;
                    if (stackTraceElement2 == null) {
                        list = configuration.getRequiredStackTraceInformation(level) == StackTraceInformation.CLASS_NAME ? 1 : 0;
                        stackTraceElement2 = Logger.getStackTraceElement(n, list != 0);
                    }
                    string2 = stackTraceElement2.getClassName();
                    list = string2.indexOf("$", 0);
                    while (list != -1) {
                        if (list >= string2.length() - 1) {
                            string2 = string2.substring(0, list);
                            break block0;
                        }
                        char c = string2.charAt(list + 1);
                        if (c < 'A' || c > 'Z') {
                            string2 = string2.substring(0, list);
                            break block0;
                        }
                        list = string2.indexOf(36, list + 2);
                    }
                    continue block11;
                }
                case METHOD: {
                    if (stackTraceElement2 == null) {
                        stackTraceElement2 = Logger.getStackTraceElement(n, false);
                    }
                    string3 = stackTraceElement2.getMethodName();
                    break;
                }
                case FILE: {
                    if (stackTraceElement2 == null) {
                        stackTraceElement2 = Logger.getStackTraceElement(n, false);
                    }
                    string4 = stackTraceElement2.getFileName();
                    break;
                }
                case LINE: {
                    if (stackTraceElement2 == null) {
                        stackTraceElement2 = Logger.getStackTraceElement(n, false);
                    }
                    n2 = stackTraceElement2.getLineNumber();
                    break;
                }
                case MESSAGE: {
                    if (object == null) break;
                    if (object instanceof String) {
                        string5 = MessageFormatter.format((String)object, objectArray);
                        break;
                    }
                    string5 = object.toString();
                    break;
                }
            }
        }
        for (int i = 0; i < logEntryArray.length; ++i) {
            LogEntry logEntry = new LogEntry(date, string, thread, map, string2, string3, string4, n2, level, string5, throwable);
            List<Token> list = listArray[i];
            if (list != null) {
                StringBuilder stringBuilder = new StringBuilder(throwable == null ? 256 : 1024);
                for (Token token : list) {
                    token.render(logEntry, stringBuilder);
                }
                stringBuilder.append(NEW_LINE);
                logEntry.setRenderedLogEntry(stringBuilder.toString());
            }
            logEntryArray[i] = logEntry;
        }
        return logEntryArray;
    }

    private static StackTraceElement getStackTraceElement(int n, boolean bl) {
        if (bl && hasSunReflection) {
            try {
                return new StackTraceElement(Reflection.getCallerClass((int)(n + 1)).getName(), "<unknown>", "<unknown>", -1);
            }
            catch (Exception exception) {
                InternalLogger.warn(exception, "Failed to get caller class from sun.reflect.Reflection");
            }
        }
        if (stackTraceMethod != null) {
            try {
                return (StackTraceElement)stackTraceMethod.invoke((Object)new Throwable(), n);
            }
            catch (Exception exception) {
                InternalLogger.warn(exception, "Failed to get single stack trace element from throwable");
            }
        }
        return new Throwable().getStackTrace()[n];
    }

    static {
        Serializable serializable;
        NEW_LINE = EnvironmentHelper.getNewLine();
        configuration = Configurator.defaultConfig().create();
        Configurator.init().activate();
        try {
            stackTraceMethod = Throwable.class.getDeclaredMethod("getStackTraceElement", Integer.TYPE);
            stackTraceMethod.setAccessible(true);
            serializable = (StackTraceElement)stackTraceMethod.invoke((Object)new Throwable(), 0);
            if (!Logger.class.getName().equals(((StackTraceElement)serializable).getClassName())) {
                stackTraceMethod = null;
            }
        }
        catch (Throwable throwable) {
            stackTraceMethod = null;
        }
        try {
            serializable = Reflection.getCallerClass((int)1);
            hasSunReflection = Logger.class.equals((Object)serializable);
        }
        catch (Throwable throwable) {
            hasSunReflection = false;
        }
    }
}

