/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.metrics;

import com.github.cassandra.jdbc.internal.metrics.Counting;
import com.github.cassandra.jdbc.internal.metrics.LongAdder;
import com.github.cassandra.jdbc.internal.metrics.Metric;
import com.github.cassandra.jdbc.internal.metrics.Reservoir;
import com.github.cassandra.jdbc.internal.metrics.Sampling;
import com.github.cassandra.jdbc.internal.metrics.Snapshot;

public class Histogram
implements Metric,
Sampling,
Counting {
    private final Reservoir reservoir;
    private final LongAdder count;

    public Histogram(Reservoir reservoir) {
        this.reservoir = reservoir;
        this.count = new LongAdder();
    }

    public void update(int value) {
        this.update((long)value);
    }

    public void update(long value) {
        this.count.increment();
        this.reservoir.update(value);
    }

    @Override
    public long getCount() {
        return this.count.sum();
    }

    @Override
    public Snapshot getSnapshot() {
        return this.reservoir.getSnapshot();
    }
}

