/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.lz4.lz4;

import com.github.cassandra.jdbc.internal.lz4.lz4.LZ4Exception;
import com.github.cassandra.jdbc.internal.lz4.lz4.LZ4FastDecompressor;
import com.github.cassandra.jdbc.internal.lz4.lz4.LZ4UnsafeUtils;
import com.github.cassandra.jdbc.internal.lz4.util.UnsafeUtils;
import com.github.cassandra.jdbc.internal.lz4.util.Utils;

final class LZ4JavaUnsafeFastDecompressor
extends LZ4FastDecompressor {
    public static final LZ4FastDecompressor INSTANCE = new LZ4JavaUnsafeFastDecompressor();

    LZ4JavaUnsafeFastDecompressor() {
    }

    @Override
    public int decompress(byte[] src, int srcOff, byte[] dest, int destOff, int destLen) {
        int literalCopyEnd;
        int literalLen;
        Utils.checkRange(src, srcOff);
        Utils.checkRange(dest, destOff, destLen);
        if (destLen == 0) {
            if (src[srcOff] != 0) {
                throw new LZ4Exception("Malformed input at " + srcOff);
            }
            return 1;
        }
        int destEnd = destOff + destLen;
        int sOff = srcOff;
        int dOff = destOff;
        while (true) {
            int matchCopyEnd;
            int token = UnsafeUtils.readByte(src, sOff) & 0xFF;
            ++sOff;
            literalLen = token >>> 4;
            if (literalLen == 15) {
                int len = -1;
                while ((len = src[sOff++]) == -1) {
                    literalLen += 255;
                }
                literalLen += len & 0xFF;
            }
            if ((literalCopyEnd = dOff + literalLen) > destEnd - 8) {
                if (literalCopyEnd != destEnd) {
                    throw new LZ4Exception("Malformed input at " + sOff);
                }
                break;
            }
            LZ4UnsafeUtils.wildArraycopy(src, sOff, dest, dOff, literalLen);
            dOff = literalCopyEnd;
            int matchDec = LZ4UnsafeUtils.readShortLittleEndian(src, sOff += literalLen);
            sOff += 2;
            int matchOff = dOff - matchDec;
            if (matchOff < destOff) {
                throw new LZ4Exception("Malformed input at " + sOff);
            }
            int matchLen = token & 0xF;
            if (matchLen == 15) {
                int len = -1;
                while ((len = src[sOff++]) == -1) {
                    matchLen += 255;
                }
                matchLen += len & 0xFF;
            }
            if ((matchCopyEnd = dOff + (matchLen += 4)) > destEnd - 8) {
                if (matchCopyEnd > destEnd) {
                    throw new LZ4Exception("Malformed input at " + sOff);
                }
                LZ4UnsafeUtils.safeIncrementalCopy(dest, matchOff, dOff, matchLen);
            } else {
                LZ4UnsafeUtils.wildIncrementalCopy(dest, matchOff, dOff, matchCopyEnd);
            }
            dOff = matchCopyEnd;
        }
        LZ4UnsafeUtils.safeArraycopy(src, sOff, dest, dOff, literalLen);
        dOff = literalCopyEnd;
        return (sOff += literalLen) - srcOff;
    }
}

