/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.lz4.lz4;

import com.github.cassandra.jdbc.internal.lz4.lz4.LZ4Exception;
import com.github.cassandra.jdbc.internal.lz4.lz4.LZ4JNI;
import com.github.cassandra.jdbc.internal.lz4.lz4.LZ4SafeDecompressor;
import com.github.cassandra.jdbc.internal.lz4.util.Utils;

final class LZ4JNISafeDecompressor
extends LZ4SafeDecompressor {
    public static final LZ4SafeDecompressor INSTANCE = new LZ4JNISafeDecompressor();

    LZ4JNISafeDecompressor() {
    }

    @Override
    public final int decompress(byte[] src, int srcOff, int srcLen, byte[] dest, int destOff, int maxDestLen) {
        Utils.checkRange(src, srcOff, srcLen);
        Utils.checkRange(dest, destOff, maxDestLen);
        int result = LZ4JNI.LZ4_decompress_safe(src, srcOff, srcLen, dest, destOff, maxDestLen);
        if (result < 0) {
            throw new LZ4Exception("Error decoding offset " + (srcOff - result) + " of input buffer");
        }
        return result;
    }
}

