/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.lz4.lz4;

import com.github.cassandra.jdbc.internal.lz4.lz4.LZ4Exception;
import com.github.cassandra.jdbc.internal.lz4.lz4.LZ4FastDecompressor;
import com.github.cassandra.jdbc.internal.lz4.lz4.LZ4JNI;
import com.github.cassandra.jdbc.internal.lz4.util.Utils;

final class LZ4JNIFastDecompressor
extends LZ4FastDecompressor {
    public static final LZ4JNIFastDecompressor INSTANCE = new LZ4JNIFastDecompressor();

    LZ4JNIFastDecompressor() {
    }

    @Override
    public final int decompress(byte[] src, int srcOff, byte[] dest, int destOff, int destLen) {
        Utils.checkRange(src, srcOff);
        Utils.checkRange(dest, destOff, destLen);
        int result = LZ4JNI.LZ4_decompress_fast(src, srcOff, dest, destOff, destLen);
        if (result < 0) {
            throw new LZ4Exception("Error decoding offset " + (srcOff - result) + " of input buffer");
        }
        return result;
    }
}

