/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.jsqlparser.util.deparser;

import com.github.cassandra.jdbc.internal.jsqlparser.statement.SetStatement;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.StatementVisitor;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.Statements;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.alter.Alter;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.create.index.CreateIndex;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.create.table.CreateTable;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.create.view.CreateView;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.delete.Delete;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.drop.Drop;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.execute.Execute;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.insert.Insert;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.merge.Merge;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.replace.Replace;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.Select;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.WithItem;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.truncate.Truncate;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.update.Update;
import com.github.cassandra.jdbc.internal.jsqlparser.util.deparser.AlterDeParser;
import com.github.cassandra.jdbc.internal.jsqlparser.util.deparser.CreateIndexDeParser;
import com.github.cassandra.jdbc.internal.jsqlparser.util.deparser.CreateTableDeParser;
import com.github.cassandra.jdbc.internal.jsqlparser.util.deparser.CreateViewDeParser;
import com.github.cassandra.jdbc.internal.jsqlparser.util.deparser.DeleteDeParser;
import com.github.cassandra.jdbc.internal.jsqlparser.util.deparser.DropDeParser;
import com.github.cassandra.jdbc.internal.jsqlparser.util.deparser.ExecuteDeParser;
import com.github.cassandra.jdbc.internal.jsqlparser.util.deparser.ExpressionDeParser;
import com.github.cassandra.jdbc.internal.jsqlparser.util.deparser.InsertDeParser;
import com.github.cassandra.jdbc.internal.jsqlparser.util.deparser.ReplaceDeParser;
import com.github.cassandra.jdbc.internal.jsqlparser.util.deparser.SelectDeParser;
import com.github.cassandra.jdbc.internal.jsqlparser.util.deparser.SetStatementDeParser;
import com.github.cassandra.jdbc.internal.jsqlparser.util.deparser.UpdateDeParser;
import java.util.Iterator;

public class StatementDeParser
implements StatementVisitor {
    private StringBuilder buffer;

    public StatementDeParser(StringBuilder buffer) {
        this.buffer = buffer;
    }

    @Override
    public void visit(CreateIndex createIndex) {
        CreateIndexDeParser createIndexDeParser = new CreateIndexDeParser(this.buffer);
        createIndexDeParser.deParse(createIndex);
    }

    @Override
    public void visit(CreateTable createTable) {
        CreateTableDeParser createTableDeParser = new CreateTableDeParser(this.buffer);
        createTableDeParser.deParse(createTable);
    }

    @Override
    public void visit(CreateView createView) {
        CreateViewDeParser createViewDeParser = new CreateViewDeParser(this.buffer);
        createViewDeParser.deParse(createView);
    }

    @Override
    public void visit(Delete delete) {
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(this.buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, this.buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        DeleteDeParser deleteDeParser = new DeleteDeParser(expressionDeParser, this.buffer);
        deleteDeParser.deParse(delete);
    }

    @Override
    public void visit(Drop drop) {
        DropDeParser dropDeParser = new DropDeParser(this.buffer);
        dropDeParser.deParse(drop);
    }

    @Override
    public void visit(Insert insert) {
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(this.buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, this.buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        InsertDeParser insertDeParser = new InsertDeParser(expressionDeParser, selectDeParser, this.buffer);
        insertDeParser.deParse(insert);
    }

    @Override
    public void visit(Replace replace) {
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(this.buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, this.buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        ReplaceDeParser replaceDeParser = new ReplaceDeParser(expressionDeParser, selectDeParser, this.buffer);
        replaceDeParser.deParse(replace);
    }

    @Override
    public void visit(Select select) {
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(this.buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, this.buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        if (select.getWithItemsList() != null && !select.getWithItemsList().isEmpty()) {
            this.buffer.append("WITH ");
            Iterator<WithItem> iter = select.getWithItemsList().iterator();
            while (iter.hasNext()) {
                WithItem withItem = iter.next();
                withItem.accept(selectDeParser);
                if (iter.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        select.getSelectBody().accept(selectDeParser);
    }

    @Override
    public void visit(Truncate truncate) {
    }

    @Override
    public void visit(Update update) {
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(this.buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, this.buffer);
        UpdateDeParser updateDeParser = new UpdateDeParser(expressionDeParser, selectDeParser, this.buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        updateDeParser.deParse(update);
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }

    @Override
    public void visit(Alter alter) {
        AlterDeParser alterDeParser = new AlterDeParser(this.buffer);
        alterDeParser.deParse(alter);
    }

    @Override
    public void visit(Statements stmts) {
        stmts.accept(this);
    }

    @Override
    public void visit(Execute execute) {
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(this.buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, this.buffer);
        ExecuteDeParser executeDeParser = new ExecuteDeParser(expressionDeParser, this.buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        executeDeParser.deParse(execute);
    }

    @Override
    public void visit(SetStatement set) {
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(this.buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, this.buffer);
        SetStatementDeParser setStatementDeparser = new SetStatementDeParser(expressionDeParser, this.buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        setStatementDeparser.deParse(set);
    }

    @Override
    public void visit(Merge merge) {
        this.buffer.append(merge.toString());
    }
}

