/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.jsqlparser.util.deparser;

import com.github.cassandra.jdbc.internal.jsqlparser.expression.Expression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.ExpressionVisitor;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.ExpressionList;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.ItemsListVisitor;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.MultiExpressionList;
import com.github.cassandra.jdbc.internal.jsqlparser.schema.Column;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.replace.Replace;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.SelectVisitor;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.SubSelect;
import java.util.Iterator;

public class ReplaceDeParser
implements ItemsListVisitor {
    private StringBuilder buffer;
    private ExpressionVisitor expressionVisitor;
    private SelectVisitor selectVisitor;

    public ReplaceDeParser() {
    }

    public ReplaceDeParser(ExpressionVisitor expressionVisitor, SelectVisitor selectVisitor, StringBuilder buffer) {
        this.buffer = buffer;
        this.expressionVisitor = expressionVisitor;
        this.selectVisitor = selectVisitor;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }

    public void deParse(Replace replace) {
        this.buffer.append("REPLACE ").append(replace.getTable().getFullyQualifiedName());
        if (replace.getItemsList() != null) {
            if (replace.getColumns() != null) {
                this.buffer.append(" (");
                for (int i = 0; i < replace.getColumns().size(); ++i) {
                    Column column = replace.getColumns().get(i);
                    this.buffer.append(column.getFullyQualifiedName());
                    if (i >= replace.getColumns().size() - 1) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(") ");
            } else {
                this.buffer.append(" ");
            }
        } else {
            this.buffer.append(" SET ");
            for (int i = 0; i < replace.getColumns().size(); ++i) {
                Column column = replace.getColumns().get(i);
                this.buffer.append(column.getFullyQualifiedName()).append("=");
                Expression expression = replace.getExpressions().get(i);
                expression.accept(this.expressionVisitor);
                if (i >= replace.getColumns().size() - 1) continue;
                this.buffer.append(", ");
            }
        }
        if (replace.getItemsList() != null) {
            replace.getItemsList().accept(this);
        }
    }

    @Override
    public void visit(ExpressionList expressionList) {
        this.buffer.append(" VALUES (");
        Iterator<Expression> iter = expressionList.getExpressions().iterator();
        while (iter.hasNext()) {
            Expression expression = iter.next();
            expression.accept(this.expressionVisitor);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(SubSelect subSelect) {
        subSelect.getSelectBody().accept(this.selectVisitor);
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }

    public void setSelectVisitor(SelectVisitor visitor) {
        this.selectVisitor = visitor;
    }

    @Override
    public void visit(MultiExpressionList multiExprList) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

