/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.jsqlparser.util.deparser;

import com.github.cassandra.jdbc.internal.jsqlparser.expression.ExpressionVisitor;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.delete.Delete;
import com.github.cassandra.jdbc.internal.jsqlparser.util.deparser.LimitDeparser;
import com.github.cassandra.jdbc.internal.jsqlparser.util.deparser.OrderByDeParser;

public class DeleteDeParser {
    private StringBuilder buffer;
    private ExpressionVisitor expressionVisitor;

    public DeleteDeParser(ExpressionVisitor expressionVisitor, StringBuilder buffer) {
        this.buffer = buffer;
        this.expressionVisitor = expressionVisitor;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }

    public void deParse(Delete delete) {
        this.buffer.append("DELETE FROM ").append(delete.getTable().getFullyQualifiedName());
        if (delete.getWhere() != null) {
            this.buffer.append(" WHERE ");
            delete.getWhere().accept(this.expressionVisitor);
        }
        if (delete.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(delete.getOrderByElements());
        }
        if (delete.getLimit() != null) {
            new LimitDeparser(this.buffer).deParse(delete.getLimit());
        }
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }
}

