/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.jsqlparser.util.deparser;

import com.github.cassandra.jdbc.internal.jsqlparser.statement.create.index.CreateIndex;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.create.table.Index;
import java.util.Iterator;

public class CreateIndexDeParser {
    private StringBuilder buffer;

    public CreateIndexDeParser(StringBuilder buffer) {
        this.buffer = buffer;
    }

    public void deParse(CreateIndex createIndex) {
        Index index = createIndex.getIndex();
        this.buffer.append("CREATE ");
        if (index.getType() != null) {
            this.buffer.append(index.getType());
            this.buffer.append(" ");
        }
        this.buffer.append("INDEX ");
        this.buffer.append(index.getName());
        this.buffer.append(" ON ");
        this.buffer.append(createIndex.getTable().getFullyQualifiedName());
        if (index.getColumnsNames() != null) {
            this.buffer.append(" (");
            Iterator<String> iter = index.getColumnsNames().iterator();
            while (iter.hasNext()) {
                String columnName = iter.next();
                this.buffer.append(columnName);
                if (!iter.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(")");
        }
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuilder buffer) {
        this.buffer = buffer;
    }
}

