/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.jsqlparser.util;

import com.github.cassandra.jdbc.internal.jsqlparser.expression.AllComparisonExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.AnalyticExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.AnyComparisonExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.BinaryExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.CaseExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.CastExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.DateValue;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.DoubleValue;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.Expression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.ExpressionVisitor;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.ExtractExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.Function;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.HexValue;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.IntervalExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.JdbcNamedParameter;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.JdbcParameter;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.JsonExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.KeepExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.LongValue;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.MySQLGroupConcat;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.NullValue;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.NumericBind;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.OracleHierarchicalExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.OracleHint;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.Parenthesis;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.RowConstructor;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.SignedExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.StringValue;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.TimeValue;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.TimestampValue;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.UserVariable;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.WhenClause;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.WithinGroupExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.arithmetic.Addition;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.arithmetic.Concat;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.arithmetic.Division;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.arithmetic.Modulo;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.arithmetic.Multiplication;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.arithmetic.Subtraction;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.conditional.AndExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.conditional.OrExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.Between;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.EqualsTo;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.ExistsExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.ExpressionList;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.GreaterThan;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.GreaterThanEquals;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.InExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.IsNullExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.ItemsListVisitor;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.LikeExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.Matches;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.MinorThan;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.MinorThanEquals;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.MultiExpressionList;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.NotEqualsTo;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.RegExpMySQLOperator;
import com.github.cassandra.jdbc.internal.jsqlparser.schema.Column;
import com.github.cassandra.jdbc.internal.jsqlparser.schema.Table;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.SetStatement;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.StatementVisitor;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.Statements;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.alter.Alter;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.create.index.CreateIndex;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.create.table.CreateTable;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.create.view.CreateView;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.delete.Delete;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.drop.Drop;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.execute.Execute;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.insert.Insert;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.merge.Merge;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.replace.Replace;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.AllColumns;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.AllTableColumns;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.FromItemVisitor;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.Join;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.LateralSubSelect;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.PlainSelect;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.Select;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.SelectBody;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.SelectExpressionItem;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.SelectItem;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.SelectItemVisitor;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.SelectVisitor;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.SetOperationList;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.SubJoin;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.SubSelect;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.TableFunction;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.ValuesList;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.WithItem;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.truncate.Truncate;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.update.Update;
import java.util.ArrayList;
import java.util.List;

public class TablesNamesFinder
implements SelectVisitor,
FromItemVisitor,
ExpressionVisitor,
ItemsListVisitor,
SelectItemVisitor,
StatementVisitor {
    private static final String NOT_SUPPORTED_YET = "Not supported yet.";
    private List<String> tables;
    private List<String> otherItemNames;

    public List<String> getTableList(Delete delete) {
        this.init();
        delete.accept(this);
        return this.tables;
    }

    public List<String> getTableList(Insert insert) {
        this.init();
        insert.accept(this);
        return this.tables;
    }

    public List<String> getTableList(Replace replace) {
        this.init();
        replace.accept(this);
        return this.tables;
    }

    public List<String> getTableList(Select select) {
        this.init();
        select.accept(this);
        return this.tables;
    }

    @Override
    public void visit(Select select) {
        if (select.getWithItemsList() != null) {
            for (WithItem withItem : select.getWithItemsList()) {
                withItem.accept(this);
            }
        }
        select.getSelectBody().accept(this);
    }

    public List<String> getTableList(Update update) {
        this.init();
        update.accept(this);
        return this.tables;
    }

    public List<String> getTableList(CreateTable create) {
        this.init();
        create.accept(this);
        return this.tables;
    }

    public List<String> getTableList(Expression expr) {
        this.init();
        expr.accept(this);
        return this.tables;
    }

    @Override
    public void visit(WithItem withItem) {
        this.otherItemNames.add(withItem.getName().toLowerCase());
        withItem.getSelectBody().accept(this);
    }

    @Override
    public void visit(PlainSelect plainSelect) {
        if (plainSelect.getSelectItems() != null) {
            for (SelectItem item : plainSelect.getSelectItems()) {
                item.accept(this);
            }
        }
        if (plainSelect.getFromItem() != null) {
            plainSelect.getFromItem().accept(this);
        }
        if (plainSelect.getJoins() != null) {
            for (Join join : plainSelect.getJoins()) {
                join.getRightItem().accept(this);
            }
        }
        if (plainSelect.getWhere() != null) {
            plainSelect.getWhere().accept(this);
        }
        if (plainSelect.getOracleHierarchical() != null) {
            plainSelect.getOracleHierarchical().accept(this);
        }
    }

    @Override
    public void visit(Table tableName) {
        String tableWholeName = tableName.getFullyQualifiedName();
        if (!this.otherItemNames.contains(tableWholeName.toLowerCase()) && !this.tables.contains(tableWholeName)) {
            this.tables.add(tableWholeName);
        }
    }

    @Override
    public void visit(SubSelect subSelect) {
        subSelect.getSelectBody().accept(this);
    }

    @Override
    public void visit(Addition addition) {
        this.visitBinaryExpression(addition);
    }

    @Override
    public void visit(AndExpression andExpression) {
        this.visitBinaryExpression(andExpression);
    }

    @Override
    public void visit(Between between) {
        between.getLeftExpression().accept(this);
        between.getBetweenExpressionStart().accept(this);
        between.getBetweenExpressionEnd().accept(this);
    }

    @Override
    public void visit(Column tableColumn) {
    }

    @Override
    public void visit(Division division) {
        this.visitBinaryExpression(division);
    }

    @Override
    public void visit(DoubleValue doubleValue) {
    }

    @Override
    public void visit(EqualsTo equalsTo) {
        this.visitBinaryExpression(equalsTo);
    }

    @Override
    public void visit(Function function) {
    }

    @Override
    public void visit(GreaterThan greaterThan) {
        this.visitBinaryExpression(greaterThan);
    }

    @Override
    public void visit(GreaterThanEquals greaterThanEquals) {
        this.visitBinaryExpression(greaterThanEquals);
    }

    @Override
    public void visit(InExpression inExpression) {
        inExpression.getLeftExpression().accept(this);
        inExpression.getRightItemsList().accept(this);
    }

    @Override
    public void visit(SignedExpression signedExpression) {
        signedExpression.getExpression().accept(this);
    }

    @Override
    public void visit(IsNullExpression isNullExpression) {
    }

    @Override
    public void visit(JdbcParameter jdbcParameter) {
    }

    @Override
    public void visit(LikeExpression likeExpression) {
        this.visitBinaryExpression(likeExpression);
    }

    @Override
    public void visit(ExistsExpression existsExpression) {
        existsExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(LongValue longValue) {
    }

    @Override
    public void visit(MinorThan minorThan) {
        this.visitBinaryExpression(minorThan);
    }

    @Override
    public void visit(MinorThanEquals minorThanEquals) {
        this.visitBinaryExpression(minorThanEquals);
    }

    @Override
    public void visit(Multiplication multiplication) {
        this.visitBinaryExpression(multiplication);
    }

    @Override
    public void visit(NotEqualsTo notEqualsTo) {
        this.visitBinaryExpression(notEqualsTo);
    }

    @Override
    public void visit(NullValue nullValue) {
    }

    @Override
    public void visit(OrExpression orExpression) {
        this.visitBinaryExpression(orExpression);
    }

    @Override
    public void visit(Parenthesis parenthesis) {
        parenthesis.getExpression().accept(this);
    }

    @Override
    public void visit(StringValue stringValue) {
    }

    @Override
    public void visit(Subtraction subtraction) {
        this.visitBinaryExpression(subtraction);
    }

    public void visitBinaryExpression(BinaryExpression binaryExpression) {
        binaryExpression.getLeftExpression().accept(this);
        binaryExpression.getRightExpression().accept(this);
    }

    @Override
    public void visit(ExpressionList expressionList) {
        for (Expression expression : expressionList.getExpressions()) {
            expression.accept(this);
        }
    }

    @Override
    public void visit(DateValue dateValue) {
    }

    @Override
    public void visit(TimestampValue timestampValue) {
    }

    @Override
    public void visit(TimeValue timeValue) {
    }

    @Override
    public void visit(CaseExpression caseExpression) {
    }

    @Override
    public void visit(WhenClause whenClause) {
    }

    @Override
    public void visit(AllComparisonExpression allComparisonExpression) {
        allComparisonExpression.getSubSelect().getSelectBody().accept(this);
    }

    @Override
    public void visit(AnyComparisonExpression anyComparisonExpression) {
        anyComparisonExpression.getSubSelect().getSelectBody().accept(this);
    }

    @Override
    public void visit(SubJoin subjoin) {
        subjoin.getLeft().accept(this);
        subjoin.getJoin().getRightItem().accept(this);
    }

    @Override
    public void visit(Concat concat) {
        this.visitBinaryExpression(concat);
    }

    @Override
    public void visit(Matches matches) {
        this.visitBinaryExpression(matches);
    }

    @Override
    public void visit(BitwiseAnd bitwiseAnd) {
        this.visitBinaryExpression(bitwiseAnd);
    }

    @Override
    public void visit(BitwiseOr bitwiseOr) {
        this.visitBinaryExpression(bitwiseOr);
    }

    @Override
    public void visit(BitwiseXor bitwiseXor) {
        this.visitBinaryExpression(bitwiseXor);
    }

    @Override
    public void visit(CastExpression cast) {
        cast.getLeftExpression().accept(this);
    }

    @Override
    public void visit(Modulo modulo) {
        this.visitBinaryExpression(modulo);
    }

    @Override
    public void visit(AnalyticExpression analytic) {
    }

    @Override
    public void visit(SetOperationList list) {
        for (SelectBody plainSelect : list.getSelects()) {
            plainSelect.accept(this);
        }
    }

    @Override
    public void visit(ExtractExpression eexpr) {
    }

    @Override
    public void visit(LateralSubSelect lateralSubSelect) {
        lateralSubSelect.getSubSelect().getSelectBody().accept(this);
    }

    @Override
    public void visit(MultiExpressionList multiExprList) {
        for (ExpressionList exprList : multiExprList.getExprList()) {
            exprList.accept(this);
        }
    }

    @Override
    public void visit(ValuesList valuesList) {
    }

    protected void init() {
        this.otherItemNames = new ArrayList<String>();
        this.tables = new ArrayList<String>();
    }

    @Override
    public void visit(IntervalExpression iexpr) {
    }

    @Override
    public void visit(JdbcNamedParameter jdbcNamedParameter) {
    }

    @Override
    public void visit(OracleHierarchicalExpression oexpr) {
        if (oexpr.getStartExpression() != null) {
            oexpr.getStartExpression().accept(this);
        }
        if (oexpr.getConnectExpression() != null) {
            oexpr.getConnectExpression().accept(this);
        }
    }

    @Override
    public void visit(RegExpMatchOperator rexpr) {
        this.visitBinaryExpression(rexpr);
    }

    @Override
    public void visit(RegExpMySQLOperator rexpr) {
        this.visitBinaryExpression(rexpr);
    }

    @Override
    public void visit(JsonExpression jsonExpr) {
    }

    @Override
    public void visit(AllColumns allColumns) {
    }

    @Override
    public void visit(AllTableColumns allTableColumns) {
    }

    @Override
    public void visit(SelectExpressionItem item) {
        item.getExpression().accept(this);
    }

    @Override
    public void visit(WithinGroupExpression wgexpr) {
    }

    @Override
    public void visit(UserVariable var) {
    }

    @Override
    public void visit(NumericBind bind) {
    }

    @Override
    public void visit(KeepExpression aexpr) {
    }

    @Override
    public void visit(MySQLGroupConcat groupConcat) {
    }

    @Override
    public void visit(Delete delete) {
        this.tables.add(delete.getTable().getName());
        if (delete.getWhere() != null) {
            delete.getWhere().accept(this);
        }
    }

    @Override
    public void visit(Update update) {
        for (Table table : update.getTables()) {
            this.tables.add(table.getName());
        }
        if (update.getExpressions() != null) {
            for (Expression expression : update.getExpressions()) {
                expression.accept(this);
            }
        }
        if (update.getFromItem() != null) {
            update.getFromItem().accept(this);
        }
        if (update.getJoins() != null) {
            for (Join join : update.getJoins()) {
                join.getRightItem().accept(this);
            }
        }
        if (update.getWhere() != null) {
            update.getWhere().accept(this);
        }
    }

    @Override
    public void visit(Insert insert) {
        this.tables.add(insert.getTable().getName());
        if (insert.getItemsList() != null) {
            insert.getItemsList().accept(this);
        }
        if (insert.getSelect() != null) {
            this.visit(insert.getSelect());
        }
    }

    @Override
    public void visit(Replace replace) {
        this.tables.add(replace.getTable().getName());
        if (replace.getExpressions() != null) {
            for (Expression expression : replace.getExpressions()) {
                expression.accept(this);
            }
        }
        if (replace.getItemsList() != null) {
            replace.getItemsList().accept(this);
        }
    }

    @Override
    public void visit(Drop drop) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public void visit(Truncate truncate) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public void visit(CreateIndex createIndex) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public void visit(CreateTable create) {
        this.tables.add(create.getTable().getFullyQualifiedName());
        if (create.getSelect() != null) {
            create.getSelect().accept(this);
        }
    }

    @Override
    public void visit(CreateView createView) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public void visit(Alter alter) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public void visit(Statements stmts) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public void visit(Execute execute) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public void visit(SetStatement set) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public void visit(RowConstructor rowConstructor) {
        for (Expression expr : rowConstructor.getExprList().getExpressions()) {
            expr.accept(this);
        }
    }

    @Override
    public void visit(HexValue hexValue) {
    }

    @Override
    public void visit(Merge merge) {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public void visit(OracleHint hint) {
    }

    @Override
    public void visit(TableFunction valuesList) {
    }
}

