/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.jsqlparser.util;

import com.github.cassandra.jdbc.internal.jsqlparser.expression.Alias;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.BinaryExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.AllColumns;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.AllTableColumns;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.PlainSelect;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.SelectBody;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.SelectExpressionItem;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.SelectItem;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.SelectItemVisitor;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.SelectVisitor;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.SetOperationList;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.WithItem;
import java.util.LinkedList;
import java.util.List;

public abstract class ConnectExpressionsVisitor
implements SelectVisitor,
SelectItemVisitor {
    private String alias = "expr";
    private final List<SelectExpressionItem> itemsExpr = new LinkedList<SelectExpressionItem>();

    public ConnectExpressionsVisitor() {
    }

    public ConnectExpressionsVisitor(String alias) {
        this.alias = alias;
    }

    protected abstract BinaryExpression createBinaryExpression();

    @Override
    public void visit(PlainSelect plainSelect) {
        for (SelectItem item : plainSelect.getSelectItems()) {
            item.accept(this);
        }
        if (this.itemsExpr.size() > 1) {
            BinaryExpression binExpr = this.createBinaryExpression();
            binExpr.setLeftExpression(this.itemsExpr.get(0).getExpression());
            for (int i = 1; i < this.itemsExpr.size() - 1; ++i) {
                binExpr.setRightExpression(this.itemsExpr.get(i).getExpression());
                BinaryExpression binExpr2 = this.createBinaryExpression();
                binExpr2.setLeftExpression(binExpr);
                binExpr = binExpr2;
            }
            binExpr.setRightExpression(this.itemsExpr.get(this.itemsExpr.size() - 1).getExpression());
            SelectExpressionItem sei = new SelectExpressionItem();
            sei.setExpression(binExpr);
            plainSelect.getSelectItems().clear();
            plainSelect.getSelectItems().add(sei);
        }
        ((SelectExpressionItem)plainSelect.getSelectItems().get(0)).setAlias(new Alias(this.alias));
    }

    @Override
    public void visit(SetOperationList setOpList) {
        for (SelectBody select : setOpList.getSelects()) {
            select.accept(this);
        }
    }

    @Override
    public void visit(WithItem withItem) {
    }

    @Override
    public void visit(AllTableColumns allTableColumns) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(AllColumns allColumns) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visit(SelectExpressionItem selectExpressionItem) {
        this.itemsExpr.add(selectExpressionItem);
    }
}

