/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.jsqlparser.statement.select;

import com.github.cassandra.jdbc.internal.jsqlparser.expression.Alias;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.MultiExpressionList;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.FromItem;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.FromItemVisitor;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.Pivot;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.PlainSelect;
import java.util.Iterator;
import java.util.List;

public class ValuesList
implements FromItem {
    private Alias alias;
    private MultiExpressionList multiExpressionList;
    private boolean noBrackets = false;
    private List<String> columnNames;

    public ValuesList() {
    }

    public ValuesList(MultiExpressionList multiExpressionList) {
        this.multiExpressionList = multiExpressionList;
    }

    @Override
    public void accept(FromItemVisitor fromItemVisitor) {
        fromItemVisitor.visit(this);
    }

    @Override
    public Alias getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    @Override
    public Pivot getPivot() {
        return null;
    }

    @Override
    public void setPivot(Pivot pivot) {
    }

    public MultiExpressionList getMultiExpressionList() {
        return this.multiExpressionList;
    }

    public void setMultiExpressionList(MultiExpressionList multiExpressionList) {
        this.multiExpressionList = multiExpressionList;
    }

    public boolean isNoBrackets() {
        return this.noBrackets;
    }

    public void setNoBrackets(boolean noBrackets) {
        this.noBrackets = noBrackets;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("(VALUES ");
        Iterator<Object> it = this.getMultiExpressionList().getExprList().iterator();
        while (it.hasNext()) {
            b.append(PlainSelect.getStringList(it.next().getExpressions(), true, !this.isNoBrackets()));
            if (!it.hasNext()) continue;
            b.append(", ");
        }
        b.append(")");
        if (this.alias != null) {
            b.append(this.alias.toString());
            if (this.columnNames != null) {
                b.append("(");
                it = this.columnNames.iterator();
                while (it.hasNext()) {
                    b.append((String)it.next());
                    if (!it.hasNext()) continue;
                    b.append(", ");
                }
                b.append(")");
            }
        }
        return b.toString();
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }
}

