/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.jsqlparser.statement.alter;

import com.github.cassandra.jdbc.internal.jsqlparser.schema.Table;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.Statement;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.StatementVisitor;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.create.table.ColDataType;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.create.table.Index;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.PlainSelect;
import java.util.List;

public class Alter
implements Statement {
    private Table table;
    private String columnName;
    private ColDataType dataType;
    private List<String> pkColumns;
    private List<String> ukColumns;
    private String ukName;
    private Index index = null;
    private String operation;
    private String constraintName;
    private boolean onDeleteRestrict;
    private boolean onDeleteSetNull;
    private boolean onDeleteCascade;
    private List<String> fkColumns;
    private String fkSourceTable;
    private List<String> fkSourceColumns;

    public boolean isOnDeleteCascade() {
        return this.onDeleteCascade;
    }

    public void setOnDeleteCascade(boolean onDeleteCascade) {
        this.onDeleteCascade = onDeleteCascade;
    }

    public boolean isOnDeleteRestrict() {
        return this.onDeleteRestrict;
    }

    public void setOnDeleteRestrict(boolean onDeleteRestrict) {
        this.onDeleteRestrict = onDeleteRestrict;
    }

    public boolean isOnDeleteSetNull() {
        return this.onDeleteSetNull;
    }

    public void setOnDeleteSetNull(boolean onDeleteSetNull) {
        this.onDeleteSetNull = onDeleteSetNull;
    }

    public List<String> getFkColumns() {
        return this.fkColumns;
    }

    public void setFkColumns(List<String> fkColumns) {
        this.fkColumns = fkColumns;
    }

    public String getFkSourceTable() {
        return this.fkSourceTable;
    }

    public void setFkSourceTable(String fkSourceTable) {
        this.fkSourceTable = fkSourceTable;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public List<String> getFkSourceColumns() {
        return this.fkSourceColumns;
    }

    public void setFkSourceColumns(List<String> fkSourceColumns) {
        this.fkSourceColumns = fkSourceColumns;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public ColDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(ColDataType dataType) {
        this.dataType = dataType;
    }

    public List<String> getPkColumns() {
        return this.pkColumns;
    }

    public void setPkColumns(List<String> pkColumns) {
        this.pkColumns = pkColumns;
    }

    public List<String> getUkColumns() {
        return this.ukColumns;
    }

    public void setUkColumns(List<String> ukColumns) {
        this.ukColumns = ukColumns;
    }

    public String getUkName() {
        return this.ukName;
    }

    public void setUkName(String ukName) {
        this.ukName = ukName;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ALTER TABLE ").append(this.table.getFullyQualifiedName()).append(" ").append(this.operation).append(" ");
        if (this.columnName != null) {
            b.append("COLUMN ").append(this.columnName);
            if (this.dataType != null) {
                b.append(" ").append(this.dataType.toString());
            }
        } else if (this.constraintName != null) {
            b.append("CONSTRAINT ").append(this.constraintName);
        } else if (this.pkColumns != null) {
            b.append("PRIMARY KEY (").append(PlainSelect.getStringList(this.pkColumns)).append(")");
        } else if (this.ukColumns != null) {
            b.append("UNIQUE KEY ").append(this.ukName).append(" (").append(PlainSelect.getStringList(this.ukColumns)).append(")");
        } else if (this.fkColumns != null) {
            b.append("FOREIGN KEY (").append(PlainSelect.getStringList(this.fkColumns)).append(") REFERENCES ").append(this.fkSourceTable).append(" (").append(PlainSelect.getStringList(this.fkSourceColumns)).append(")");
            if (this.isOnDeleteCascade()) {
                b.append(" ON DELETE CASCADE");
            } else if (this.isOnDeleteRestrict()) {
                b.append(" ON DELETE RESTRICT");
            } else if (this.isOnDeleteSetNull()) {
                b.append(" ON DELETE SET NULL");
            }
        } else if (this.index != null) {
            b.append(this.index);
        }
        return b.toString();
    }
}

