/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.jsqlparser.schema;

import com.github.cassandra.jdbc.internal.jsqlparser.schema.MultiPartName;
import com.github.cassandra.jdbc.internal.jsqlparser.schema.Server;

public final class Database
implements MultiPartName {
    private Server server;
    private String databaseName;

    public Database(String databaseName) {
        this.setDatabaseName(databaseName);
    }

    public Database(Server server, String databaseName) {
        this.setServer(server);
        this.setDatabaseName(databaseName);
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Override
    public String getFullyQualifiedName() {
        String fqn = "";
        if (this.server != null) {
            fqn = fqn + this.server.getFullyQualifiedName();
        }
        if (!fqn.isEmpty()) {
            fqn = fqn + ".";
        }
        if (this.databaseName != null) {
            fqn = fqn + this.databaseName;
        }
        return fqn;
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }
}

