/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.jsqlparser.schema;

import com.github.cassandra.jdbc.internal.jsqlparser.expression.Expression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.ExpressionVisitor;
import com.github.cassandra.jdbc.internal.jsqlparser.parser.ASTNodeAccessImpl;
import com.github.cassandra.jdbc.internal.jsqlparser.schema.MultiPartName;
import com.github.cassandra.jdbc.internal.jsqlparser.schema.Table;

public final class Column
extends ASTNodeAccessImpl
implements Expression,
MultiPartName {
    private Table table;
    private String columnName;

    public Column() {
    }

    public Column(Table table, String columnName) {
        this.setTable(table);
        this.setColumnName(columnName);
    }

    public Column(String columnName) {
        this(null, columnName);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    @Override
    public String getFullyQualifiedName() {
        StringBuilder fqn = new StringBuilder();
        if (this.table != null) {
            fqn.append(this.table.getFullyQualifiedName());
        }
        if (fqn.length() > 0) {
            fqn.append('.');
        }
        if (this.columnName != null) {
            fqn.append(this.columnName);
        }
        return fqn.toString();
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }
}

