/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.jsqlparser.expression;

import com.github.cassandra.jdbc.internal.jsqlparser.expression.Expression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.ExpressionVisitor;

public class StringValue
implements Expression {
    private String value = "";

    public StringValue(String escapedValue) {
        this.value = escapedValue.substring(1, escapedValue.length() - 1);
    }

    public String getValue() {
        return this.value;
    }

    public String getNotExcapedValue() {
        StringBuilder buffer = new StringBuilder(this.value);
        int index = 0;
        int deletesNum = 0;
        while ((index = this.value.indexOf("''", index)) != -1) {
            buffer.deleteCharAt(index - deletesNum);
            index += 2;
            ++deletesNum;
        }
        return buffer.toString();
    }

    public void setValue(String string) {
        this.value = string;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        return "'" + this.value + "'";
    }
}

