/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.jsqlparser.expression;

import com.github.cassandra.jdbc.internal.jsqlparser.expression.Expression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.ExpressionVisitor;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.OrderByElement;
import java.util.List;

public class KeepExpression
implements Expression {
    private String name;
    private List<OrderByElement> orderByElements;
    private boolean first = false;

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderByElements = orderByElements;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isFirst() {
        return this.first;
    }

    public void setFirst(boolean first) {
        this.first = first;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("KEEP (").append(this.name);
        b.append(" ").append(this.first ? "FIRST" : "LAST").append(" ");
        this.toStringOrderByElements(b);
        b.append(")");
        return b.toString();
    }

    private void toStringOrderByElements(StringBuilder b) {
        if (this.orderByElements != null && !this.orderByElements.isEmpty()) {
            b.append("ORDER BY ");
            for (int i = 0; i < this.orderByElements.size(); ++i) {
                if (i > 0) {
                    b.append(", ");
                }
                b.append(this.orderByElements.get(i).toString());
            }
        }
    }
}

