/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.jsqlparser.expression;

import com.github.cassandra.jdbc.internal.jsqlparser.expression.Expression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.ExpressionVisitor;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.KeepExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.ExpressionList;

public class Function
implements Expression {
    private String name;
    private ExpressionList parameters;
    private boolean allColumns = false;
    private boolean distinct = false;
    private boolean isEscaped = false;
    private String attribute;
    private KeepExpression keep = null;

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isAllColumns() {
        return this.allColumns;
    }

    public void setAllColumns(boolean b) {
        this.allColumns = b;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean b) {
        this.distinct = b;
    }

    public ExpressionList getParameters() {
        return this.parameters;
    }

    public void setParameters(ExpressionList list) {
        this.parameters = list;
    }

    public boolean isEscaped() {
        return this.isEscaped;
    }

    public void setEscaped(boolean isEscaped) {
        this.isEscaped = isEscaped;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public KeepExpression getKeep() {
        return this.keep;
    }

    public void setKeep(KeepExpression keep) {
        this.keep = keep;
    }

    public String toString() {
        String params;
        if (this.parameters != null) {
            params = this.parameters.toString();
            if (this.isDistinct()) {
                params = params.replaceFirst("\\(", "(DISTINCT ");
            } else if (this.isAllColumns()) {
                params = params.replaceFirst("\\(", "(ALL ");
            }
        } else {
            params = this.isAllColumns() ? "(*)" : "()";
        }
        String ans = this.name + "" + params + "";
        if (this.attribute != null) {
            ans = ans + "." + this.attribute;
        }
        if (this.keep != null) {
            ans = ans + " " + this.keep.toString();
        }
        if (this.isEscaped) {
            ans = "{fn " + ans + "}";
        }
        return ans;
    }
}

