/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.jsqlparser.expression;

import com.github.cassandra.jdbc.internal.jsqlparser.expression.AllComparisonExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.AnalyticExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.AnyComparisonExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.BinaryExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.CaseExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.CastExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.DateValue;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.DoubleValue;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.Expression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.ExpressionVisitor;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.ExtractExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.Function;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.HexValue;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.IntervalExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.JdbcNamedParameter;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.JdbcParameter;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.JsonExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.KeepExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.LongValue;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.MySQLGroupConcat;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.NullValue;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.NumericBind;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.OracleHierarchicalExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.OracleHint;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.Parenthesis;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.RowConstructor;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.SignedExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.StringValue;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.TimeValue;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.TimestampValue;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.UserVariable;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.WhenClause;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.WithinGroupExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.arithmetic.Addition;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.arithmetic.Concat;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.arithmetic.Division;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.arithmetic.Modulo;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.arithmetic.Multiplication;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.arithmetic.Subtraction;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.conditional.AndExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.conditional.OrExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.Between;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.EqualsTo;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.ExistsExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.ExpressionList;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.GreaterThan;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.GreaterThanEquals;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.InExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.IsNullExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.ItemsListVisitor;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.LikeExpression;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.Matches;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.MinorThan;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.MinorThanEquals;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.MultiExpressionList;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.NotEqualsTo;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import com.github.cassandra.jdbc.internal.jsqlparser.expression.operators.relational.RegExpMySQLOperator;
import com.github.cassandra.jdbc.internal.jsqlparser.schema.Column;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.AllColumns;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.AllTableColumns;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.ExpressionListItem;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.FunctionItem;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.OrderByElement;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.Pivot;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.PivotVisitor;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.PivotXml;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.SelectExpressionItem;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.SelectItemVisitor;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.SelectVisitor;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.SubSelect;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.WithItem;

public class ExpressionVisitorAdapter
implements ExpressionVisitor,
ItemsListVisitor,
PivotVisitor,
SelectItemVisitor {
    private SelectVisitor selectVisitor;

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setSelectVisitor(SelectVisitor selectVisitor) {
        this.selectVisitor = selectVisitor;
    }

    @Override
    public void visit(NullValue value) {
    }

    @Override
    public void visit(Function function) {
        if (function.getParameters() != null) {
            function.getParameters().accept(this);
        }
        if (function.getKeep() != null) {
            function.getKeep().accept(this);
        }
    }

    @Override
    public void visit(SignedExpression expr) {
        expr.getExpression().accept(this);
    }

    @Override
    public void visit(JdbcParameter parameter) {
    }

    @Override
    public void visit(JdbcNamedParameter parameter) {
    }

    @Override
    public void visit(DoubleValue value) {
    }

    @Override
    public void visit(LongValue value) {
    }

    @Override
    public void visit(DateValue value) {
    }

    @Override
    public void visit(TimeValue value) {
    }

    @Override
    public void visit(TimestampValue value) {
    }

    @Override
    public void visit(Parenthesis parenthesis) {
        parenthesis.getExpression().accept(this);
    }

    @Override
    public void visit(StringValue value) {
    }

    @Override
    public void visit(Addition expr) {
        this.visitBinaryExpression(expr);
    }

    @Override
    public void visit(Division expr) {
        this.visitBinaryExpression(expr);
    }

    @Override
    public void visit(Multiplication expr) {
        this.visitBinaryExpression(expr);
    }

    @Override
    public void visit(Subtraction expr) {
        this.visitBinaryExpression(expr);
    }

    @Override
    public void visit(AndExpression expr) {
        this.visitBinaryExpression(expr);
    }

    @Override
    public void visit(OrExpression expr) {
        this.visitBinaryExpression(expr);
    }

    @Override
    public void visit(Between expr) {
        expr.getLeftExpression().accept(this);
        expr.getBetweenExpressionStart().accept(this);
        expr.getBetweenExpressionEnd().accept(this);
    }

    @Override
    public void visit(EqualsTo expr) {
        this.visitBinaryExpression(expr);
    }

    @Override
    public void visit(GreaterThan expr) {
        this.visitBinaryExpression(expr);
    }

    @Override
    public void visit(GreaterThanEquals expr) {
        this.visitBinaryExpression(expr);
    }

    @Override
    public void visit(InExpression expr) {
        if (expr.getLeftExpression() != null) {
            expr.getLeftExpression().accept(this);
        } else if (expr.getLeftItemsList() != null) {
            expr.getLeftItemsList().accept(this);
        }
        expr.getRightItemsList().accept(this);
    }

    @Override
    public void visit(IsNullExpression expr) {
        expr.getLeftExpression().accept(this);
    }

    @Override
    public void visit(LikeExpression expr) {
        this.visitBinaryExpression(expr);
    }

    @Override
    public void visit(MinorThan expr) {
        this.visitBinaryExpression(expr);
    }

    @Override
    public void visit(MinorThanEquals expr) {
        this.visitBinaryExpression(expr);
    }

    @Override
    public void visit(NotEqualsTo expr) {
        this.visitBinaryExpression(expr);
    }

    @Override
    public void visit(Column column) {
    }

    @Override
    public void visit(SubSelect subSelect) {
        if (this.selectVisitor != null) {
            for (WithItem item : subSelect.getWithItemsList()) {
                item.accept(this.selectVisitor);
            }
            subSelect.getSelectBody().accept(this.selectVisitor);
        }
        if (subSelect.getPivot() != null) {
            subSelect.getPivot().accept(this);
        }
    }

    @Override
    public void visit(CaseExpression expr) {
        expr.getSwitchExpression().accept(this);
        for (Expression x : expr.getWhenClauses()) {
            x.accept(this);
        }
        expr.getElseExpression().accept(this);
    }

    @Override
    public void visit(WhenClause expr) {
        expr.getWhenExpression().accept(this);
        expr.getThenExpression().accept(this);
    }

    @Override
    public void visit(ExistsExpression expr) {
        expr.getRightExpression().accept(this);
    }

    @Override
    public void visit(AllComparisonExpression expr) {
    }

    @Override
    public void visit(AnyComparisonExpression expr) {
    }

    @Override
    public void visit(Concat expr) {
        this.visitBinaryExpression(expr);
    }

    @Override
    public void visit(Matches expr) {
        this.visitBinaryExpression(expr);
    }

    @Override
    public void visit(BitwiseAnd expr) {
        this.visitBinaryExpression(expr);
    }

    @Override
    public void visit(BitwiseOr expr) {
        this.visitBinaryExpression(expr);
    }

    @Override
    public void visit(BitwiseXor expr) {
        this.visitBinaryExpression(expr);
    }

    @Override
    public void visit(CastExpression expr) {
        expr.getLeftExpression().accept(this);
    }

    @Override
    public void visit(Modulo expr) {
        this.visitBinaryExpression(expr);
    }

    @Override
    public void visit(AnalyticExpression expr) {
        expr.getExpression().accept(this);
        expr.getDefaultValue().accept(this);
        expr.getOffset().accept(this);
        if (expr.getKeep() != null) {
            expr.getKeep().accept(this);
        }
        for (OrderByElement element : expr.getOrderByElements()) {
            element.getExpression().accept(this);
        }
        expr.getWindowElement().getRange().getStart().getExpression().accept(this);
        expr.getWindowElement().getRange().getEnd().getExpression().accept(this);
        expr.getWindowElement().getOffset().getExpression().accept(this);
    }

    @Override
    public void visit(ExtractExpression expr) {
        expr.getExpression().accept(this);
    }

    @Override
    public void visit(IntervalExpression expr) {
    }

    @Override
    public void visit(OracleHierarchicalExpression expr) {
        expr.getConnectExpression().accept(this);
        expr.getStartExpression().accept(this);
    }

    @Override
    public void visit(RegExpMatchOperator expr) {
        this.visitBinaryExpression(expr);
    }

    @Override
    public void visit(ExpressionList expressionList) {
        for (Expression expr : expressionList.getExpressions()) {
            expr.accept(this);
        }
    }

    @Override
    public void visit(MultiExpressionList multiExprList) {
        for (ExpressionList list : multiExprList.getExprList()) {
            this.visit(list);
        }
    }

    protected void visitBinaryExpression(BinaryExpression expr) {
        expr.getLeftExpression().accept(this);
        expr.getRightExpression().accept(this);
    }

    @Override
    public void visit(JsonExpression jsonExpr) {
        this.visit(jsonExpr.getColumn());
    }

    @Override
    public void visit(RegExpMySQLOperator expr) {
        this.visitBinaryExpression(expr);
    }

    @Override
    public void visit(WithinGroupExpression wgexpr) {
        wgexpr.getExprList().accept(this);
        for (OrderByElement element : wgexpr.getOrderByElements()) {
            element.getExpression().accept(this);
        }
    }

    @Override
    public void visit(UserVariable var) {
    }

    @Override
    public void visit(NumericBind bind) {
    }

    @Override
    public void visit(KeepExpression expr) {
        for (OrderByElement element : expr.getOrderByElements()) {
            element.getExpression().accept(this);
        }
    }

    @Override
    public void visit(MySQLGroupConcat groupConcat) {
        for (Expression expr : groupConcat.getExpressionList().getExpressions()) {
            expr.accept(this);
        }
        if (groupConcat.getOrderByElements() != null) {
            for (OrderByElement element : groupConcat.getOrderByElements()) {
                element.getExpression().accept(this);
            }
        }
    }

    @Override
    public void visit(Pivot pivot) {
        for (FunctionItem functionItem : pivot.getFunctionItems()) {
            functionItem.getFunction().accept(this);
        }
        for (Column column : pivot.getForColumns()) {
            column.accept(this);
        }
        if (pivot.getSingleInItems() != null) {
            for (SelectExpressionItem selectExpressionItem : pivot.getSingleInItems()) {
                selectExpressionItem.accept(this);
            }
        }
        if (pivot.getMultiInItems() != null) {
            for (ExpressionListItem expressionListItem : pivot.getMultiInItems()) {
                expressionListItem.getExpressionList().accept(this);
            }
        }
    }

    @Override
    public void visit(PivotXml pivot) {
        for (FunctionItem item : pivot.getFunctionItems()) {
            item.getFunction().accept(this);
        }
        for (Column col : pivot.getForColumns()) {
            col.accept(this);
        }
        if (pivot.getInSelect() != null && this.selectVisitor != null) {
            pivot.getInSelect().accept(this.selectVisitor);
        }
    }

    @Override
    public void visit(AllColumns allColumns) {
    }

    @Override
    public void visit(AllTableColumns allTableColumns) {
    }

    @Override
    public void visit(SelectExpressionItem selectExpressionItem) {
        selectExpressionItem.getExpression().accept(this);
    }

    @Override
    public void visit(RowConstructor rowConstructor) {
        for (Expression expr : rowConstructor.getExprList().getExpressions()) {
            expr.accept(this);
        }
    }

    @Override
    public void visit(HexValue hexValue) {
    }

    @Override
    public void visit(OracleHint hint) {
    }
}

