/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.jamm;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import sun.misc.Unsafe;

public abstract class MemoryLayoutSpecification {
    static final Unsafe unsafe;
    public static final MemoryLayoutSpecification SPEC;

    public abstract int getArrayHeaderSize();

    public abstract int getObjectHeaderSize();

    public abstract int getObjectPadding();

    public abstract int getReferenceSize();

    public abstract int getSuperclassFieldPadding();

    public static boolean hasUnsafe() {
        return unsafe != null;
    }

    public static int sizeOf(Field field) {
        return MemoryLayoutSpecification.sizeOfField(field.getType());
    }

    public static int sizeOfField(Class<?> type) {
        if (!type.isPrimitive()) {
            return SPEC.getReferenceSize();
        }
        if (type == Boolean.TYPE || type == Byte.TYPE) {
            return 1;
        }
        if (type == Character.TYPE || type == Short.TYPE) {
            return 2;
        }
        if (type == Float.TYPE || type == Integer.TYPE) {
            return 4;
        }
        if (type == Double.TYPE || type == Long.TYPE) {
            return 8;
        }
        throw new IllegalStateException();
    }

    public static long sizeOf(Object obj) {
        Class<?> type = obj.getClass();
        if (type.isArray()) {
            return MemoryLayoutSpecification.sizeOfArray(obj, type);
        }
        return MemoryLayoutSpecification.sizeOfInstance(type);
    }

    public static long sizeOfWithUnsafe(Object obj) {
        Class<?> type = obj.getClass();
        if (type.isArray()) {
            return MemoryLayoutSpecification.sizeOfArray(obj, type);
        }
        return MemoryLayoutSpecification.sizeOfInstanceWithUnsafe(type);
    }

    public static long sizeOfInstance(Class<?> type) {
        long size = (long)SPEC.getObjectHeaderSize() + MemoryLayoutSpecification.sizeOfDeclaredFields(type);
        while ((type = type.getSuperclass()) != Object.class && type != null) {
            size += MemoryLayoutSpecification.roundTo(MemoryLayoutSpecification.sizeOfDeclaredFields(type), SPEC.getSuperclassFieldPadding());
        }
        return MemoryLayoutSpecification.roundTo(size, SPEC.getObjectPadding());
    }

    public static long sizeOfInstanceWithUnsafe(Class<?> type) {
        while (type != null) {
            long size = 0L;
            for (Field f : MemoryLayoutSpecification.declaredFieldsOf(type)) {
                size = Math.max(size, unsafe.objectFieldOffset(f) + (long)MemoryLayoutSpecification.sizeOf(f));
            }
            if (size > 0L) {
                return MemoryLayoutSpecification.roundTo(size, SPEC.getObjectPadding());
            }
            type = type.getSuperclass();
        }
        return MemoryLayoutSpecification.roundTo(SPEC.getObjectHeaderSize(), SPEC.getObjectPadding());
    }

    public static long sizeOfArray(Object instance, Class<?> type) {
        return MemoryLayoutSpecification.sizeOfArray(Array.getLength(instance), MemoryLayoutSpecification.sizeOfField(type.getComponentType()));
    }

    public static long sizeOfArray(int length, Class<?> type) {
        return MemoryLayoutSpecification.sizeOfArray(length, MemoryLayoutSpecification.sizeOfField(type.getComponentType()));
    }

    public static long sizeOfArray(int length, long elementSize) {
        return MemoryLayoutSpecification.roundTo((long)SPEC.getArrayHeaderSize() + (long)length * elementSize, SPEC.getObjectPadding());
    }

    private static long sizeOfDeclaredFields(Class<?> type) {
        long size = 0L;
        for (Field f : MemoryLayoutSpecification.declaredFieldsOf(type)) {
            size += (long)MemoryLayoutSpecification.sizeOf(f);
        }
        return size;
    }

    private static Iterable<Field> declaredFieldsOf(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field f : type.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            fields.add(f);
        }
        return fields;
    }

    private static long roundTo(long x, int multiple) {
        return (x + (long)multiple - 1L) / (long)multiple * (long)multiple;
    }

    private static MemoryLayoutSpecification getEffectiveMemoryLayoutSpecification() {
        String dataModel = System.getProperty("sun.arch.data.model");
        if ("32".equals(dataModel)) {
            return new MemoryLayoutSpecification(){

                @Override
                public int getArrayHeaderSize() {
                    return 12;
                }

                @Override
                public int getObjectHeaderSize() {
                    return 8;
                }

                @Override
                public int getObjectPadding() {
                    return 8;
                }

                @Override
                public int getReferenceSize() {
                    return 4;
                }

                @Override
                public int getSuperclassFieldPadding() {
                    return 4;
                }
            };
        }
        String strVmVersion = System.getProperty("java.vm.version");
        int vmVersion = Integer.parseInt(strVmVersion.substring(0, strVmVersion.indexOf(46)));
        final int alignment = MemoryLayoutSpecification.getAlignment();
        if (vmVersion >= 17) {
            long maxMemory = 0L;
            for (MemoryPoolMXBean mp : ManagementFactory.getMemoryPoolMXBeans()) {
                maxMemory += mp.getUsage().getMax();
            }
            if (maxMemory < 0x780000000L) {
                return new MemoryLayoutSpecification(){

                    @Override
                    public int getArrayHeaderSize() {
                        return 16;
                    }

                    @Override
                    public int getObjectHeaderSize() {
                        return 12;
                    }

                    @Override
                    public int getObjectPadding() {
                        return alignment;
                    }

                    @Override
                    public int getReferenceSize() {
                        return 4;
                    }

                    @Override
                    public int getSuperclassFieldPadding() {
                        return 4;
                    }
                };
            }
        }
        return new MemoryLayoutSpecification(){

            @Override
            public int getArrayHeaderSize() {
                return 24;
            }

            @Override
            public int getObjectHeaderSize() {
                return 16;
            }

            @Override
            public int getObjectPadding() {
                return alignment;
            }

            @Override
            public int getReferenceSize() {
                return 8;
            }

            @Override
            public int getSuperclassFieldPadding() {
                return 8;
            }
        };
    }

    private static int getAlignment() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        for (String arg : runtimeMxBean.getInputArguments()) {
            if (!arg.startsWith("-XX:ObjectAlignmentInBytes=")) continue;
            try {
                return Integer.parseInt(arg.substring("-XX:ObjectAlignmentInBytes=".length()));
            }
            catch (Exception exception) {
            }
        }
        return 8;
    }

    static {
        Unsafe tryGetUnsafe;
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            tryGetUnsafe = (Unsafe)field.get(null);
        }
        catch (Exception e) {
            tryGetUnsafe = null;
        }
        unsafe = tryGetUnsafe;
        SPEC = MemoryLayoutSpecification.getEffectiveMemoryLayoutSpecification();
    }
}

