/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.datastax.shaded.netty.handler.codec.string;

import com.github.cassandra.jdbc.internal.datastax.shaded.netty.buffer.ByteBufUtil;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.channel.ChannelHandler;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.channel.ChannelHandlerContext;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.handler.codec.MessageToMessageEncoder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;

@ChannelHandler.Sharable
public class StringEncoder
extends MessageToMessageEncoder<CharSequence> {
    private final Charset charset;

    public StringEncoder() {
        this(Charset.defaultCharset());
    }

    public StringEncoder(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.charset = charset;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, CharSequence msg, List<Object> out) throws Exception {
        if (msg.length() == 0) {
            return;
        }
        out.add(ByteBufUtil.encodeString(ctx.alloc(), CharBuffer.wrap(msg), this.charset));
    }
}

