/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.datastax.shaded.netty.handler.codec.serialization;

import com.github.cassandra.jdbc.internal.datastax.shaded.netty.buffer.ByteBuf;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.buffer.ByteBufOutputStream;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.channel.ChannelHandlerContext;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.handler.codec.MessageToByteEncoder;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.util.Attribute;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.util.AttributeKey;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class CompatibleObjectEncoder
extends MessageToByteEncoder<Serializable> {
    private static final AttributeKey<ObjectOutputStream> OOS = AttributeKey.valueOf(CompatibleObjectEncoder.class.getName() + ".OOS");
    private final int resetInterval;
    private int writtenObjects;

    public CompatibleObjectEncoder() {
        this(16);
    }

    public CompatibleObjectEncoder(int resetInterval) {
        if (resetInterval < 0) {
            throw new IllegalArgumentException("resetInterval: " + resetInterval);
        }
        this.resetInterval = resetInterval;
    }

    protected ObjectOutputStream newObjectOutputStream(OutputStream out) throws Exception {
        return new ObjectOutputStream(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, Serializable msg, ByteBuf out) throws Exception {
        ObjectOutputStream newOos;
        Attribute<ObjectOutputStream> oosAttr = ctx.attr(OOS);
        ObjectOutputStream oos = oosAttr.get();
        if (oos == null && (newOos = oosAttr.setIfAbsent(oos = this.newObjectOutputStream(new ByteBufOutputStream(out)))) != null) {
            oos = newOos;
        }
        ObjectOutputStream objectOutputStream = oos;
        synchronized (objectOutputStream) {
            if (this.resetInterval != 0) {
                ++this.writtenObjects;
                if (this.writtenObjects % this.resetInterval == 0) {
                    oos.reset();
                }
            }
            oos.writeObject(msg);
            oos.flush();
        }
    }
}

