/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.datastax.shaded.netty.handler.codec.protobuf;

import com.github.cassandra.jdbc.internal.datastax.shaded.netty.buffer.ByteBuf;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.buffer.ByteBufOutputStream;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.channel.ChannelHandler;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.channel.ChannelHandlerContext;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.handler.codec.MessageToByteEncoder;
import com.github.cassandra.jdbc.internal.google.protobuf.CodedOutputStream;
import java.io.OutputStream;

@ChannelHandler.Sharable
public class ProtobufVarint32LengthFieldPrepender
extends MessageToByteEncoder<ByteBuf> {
    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
        int bodyLen = msg.readableBytes();
        int headerLen = CodedOutputStream.computeRawVarint32Size((int)bodyLen);
        out.ensureWritable(headerLen + bodyLen);
        CodedOutputStream headerOut = CodedOutputStream.newInstance((OutputStream)new ByteBufOutputStream(out), (int)headerLen);
        headerOut.writeRawVarint32(bodyLen);
        headerOut.flush();
        out.writeBytes(msg, msg.readerIndex(), bodyLen);
    }
}

