/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.datastax.shaded.netty.handler.codec.base64;

import com.github.cassandra.jdbc.internal.datastax.shaded.netty.buffer.ByteBuf;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.channel.ChannelHandler;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.channel.ChannelHandlerContext;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.handler.codec.MessageToMessageDecoder;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.handler.codec.base64.Base64;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.handler.codec.base64.Base64Dialect;
import java.util.List;

@ChannelHandler.Sharable
public class Base64Decoder
extends MessageToMessageDecoder<ByteBuf> {
    private final Base64Dialect dialect;

    public Base64Decoder() {
        this(Base64Dialect.STANDARD);
    }

    public Base64Decoder(Base64Dialect dialect) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        this.dialect = dialect;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        out.add(Base64.decode(msg, msg.readerIndex(), msg.readableBytes(), this.dialect));
    }
}

