/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.datastax.shaded.netty.channel;

import com.github.cassandra.jdbc.internal.datastax.shaded.netty.channel.ChannelHandler;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.channel.ChannelHandlerContext;
import com.github.cassandra.jdbc.internal.datastax.shaded.netty.util.internal.InternalThreadLocalMap;
import java.util.Map;

public abstract class ChannelHandlerAdapter
implements ChannelHandler {
    boolean added;

    public boolean isSharable() {
        Class<?> clazz = this.getClass();
        Map<Class<?>, Boolean> cache = InternalThreadLocalMap.get().handlerSharableCache();
        Boolean sharable = cache.get(clazz);
        if (sharable == null) {
            sharable = clazz.isAnnotationPresent(ChannelHandler.Sharable.class);
            cache.put(clazz, sharable);
        }
        return sharable;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.fireExceptionCaught(cause);
    }
}

