/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.datastax.shaded.netty.buffer;

final class HeapByteBufUtil {
    static byte getByte(byte[] memory, int index) {
        return memory[index];
    }

    static short getShort(byte[] memory, int index) {
        return (short)(memory[index] << 8 | memory[index + 1] & 0xFF);
    }

    static int getUnsignedMedium(byte[] memory, int index) {
        return (memory[index] & 0xFF) << 16 | (memory[index + 1] & 0xFF) << 8 | memory[index + 2] & 0xFF;
    }

    static int getInt(byte[] memory, int index) {
        return (memory[index] & 0xFF) << 24 | (memory[index + 1] & 0xFF) << 16 | (memory[index + 2] & 0xFF) << 8 | memory[index + 3] & 0xFF;
    }

    static long getLong(byte[] memory, int index) {
        return ((long)memory[index] & 0xFFL) << 56 | ((long)memory[index + 1] & 0xFFL) << 48 | ((long)memory[index + 2] & 0xFFL) << 40 | ((long)memory[index + 3] & 0xFFL) << 32 | ((long)memory[index + 4] & 0xFFL) << 24 | ((long)memory[index + 5] & 0xFFL) << 16 | ((long)memory[index + 6] & 0xFFL) << 8 | (long)memory[index + 7] & 0xFFL;
    }

    static void setByte(byte[] memory, int index, int value) {
        memory[index] = (byte)value;
    }

    static void setShort(byte[] memory, int index, int value) {
        memory[index] = (byte)(value >>> 8);
        memory[index + 1] = (byte)value;
    }

    static void setMedium(byte[] memory, int index, int value) {
        memory[index] = (byte)(value >>> 16);
        memory[index + 1] = (byte)(value >>> 8);
        memory[index + 2] = (byte)value;
    }

    static void setInt(byte[] memory, int index, int value) {
        memory[index] = (byte)(value >>> 24);
        memory[index + 1] = (byte)(value >>> 16);
        memory[index + 2] = (byte)(value >>> 8);
        memory[index + 3] = (byte)value;
    }

    static void setLong(byte[] memory, int index, long value) {
        memory[index] = (byte)(value >>> 56);
        memory[index + 1] = (byte)(value >>> 48);
        memory[index + 2] = (byte)(value >>> 40);
        memory[index + 3] = (byte)(value >>> 32);
        memory[index + 4] = (byte)(value >>> 24);
        memory[index + 5] = (byte)(value >>> 16);
        memory[index + 6] = (byte)(value >>> 8);
        memory[index + 7] = (byte)value;
    }

    private HeapByteBufUtil() {
    }
}

