/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.datastax.driver.extras.codecs.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.github.cassandra.jdbc.internal.datastax.driver.core.DataType;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ParseUtils;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ProtocolVersion;
import com.github.cassandra.jdbc.internal.datastax.driver.core.TypeCodec;
import com.github.cassandra.jdbc.internal.datastax.driver.core.exceptions.InvalidTypeException;
import com.github.cassandra.jdbc.internal.datastax.driver.core.utils.Bytes;
import java.io.IOException;
import java.nio.ByteBuffer;

public class JacksonJsonCodec<T>
extends TypeCodec<T> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JacksonJsonCodec(Class<T> javaType) {
        super(DataType.varchar(), javaType);
    }

    @Override
    public ByteBuffer serialize(T value, ProtocolVersion protocolVersion) throws InvalidTypeException {
        if (value == null) {
            return null;
        }
        try {
            return ByteBuffer.wrap(this.objectMapper.writeValueAsBytes(value));
        }
        catch (JsonProcessingException e) {
            throw new InvalidTypeException(e.getMessage(), e);
        }
    }

    @Override
    public T deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
        if (bytes == null) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue(Bytes.getArray(bytes), this.toJacksonJavaType());
        }
        catch (IOException e) {
            throw new InvalidTypeException(e.getMessage(), e);
        }
    }

    @Override
    public String format(T value) throws InvalidTypeException {
        String json;
        if (value == null) {
            return "NULL";
        }
        try {
            json = this.objectMapper.writeValueAsString(value);
        }
        catch (IOException e) {
            throw new InvalidTypeException(e.getMessage(), e);
        }
        return ParseUtils.quote(json);
    }

    @Override
    public T parse(String value) throws InvalidTypeException {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (!ParseUtils.isQuoted(value)) {
            throw new InvalidTypeException("JSON strings must be enclosed by single quotes");
        }
        String json = ParseUtils.unquote(value);
        try {
            return (T)this.objectMapper.readValue(json, this.toJacksonJavaType());
        }
        catch (IOException e) {
            throw new InvalidTypeException(e.getMessage(), e);
        }
    }

    protected JavaType toJacksonJavaType() {
        return TypeFactory.defaultInstance().constructType(this.getJavaType().getType());
    }
}

