/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.datastax.driver.extras.codecs.joda;

import com.github.cassandra.jdbc.internal.datastax.driver.core.DataType;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ParseUtils;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ProtocolVersion;
import com.github.cassandra.jdbc.internal.datastax.driver.core.TupleType;
import com.github.cassandra.jdbc.internal.datastax.driver.core.TypeCodec;
import com.github.cassandra.jdbc.internal.datastax.driver.core.exceptions.InvalidTypeException;
import com.github.cassandra.jdbc.internal.google.common.base.Preconditions;
import com.github.cassandra.jdbc.internal.joda.time.DateTime;
import com.github.cassandra.jdbc.internal.joda.time.DateTimeZone;
import com.github.cassandra.jdbc.internal.joda.time.format.DateTimeFormat;
import com.github.cassandra.jdbc.internal.joda.time.format.DateTimeFormatter;
import com.github.cassandra.jdbc.internal.joda.time.format.DateTimeFormatterBuilder;
import com.github.cassandra.jdbc.internal.joda.time.format.ISODateTimeFormat;
import java.nio.ByteBuffer;
import java.util.List;

public class DateTimeCodec
extends TypeCodec.AbstractTupleCodec<DateTime> {
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(ISODateTimeFormat.dateOptionalTimeParser().getParser()).appendOptional(new DateTimeFormatterBuilder().appendTimeZoneOffset("Z", true, 2, 4).toParser()).toFormatter().withZoneUTC();
    private static final DateTimeFormatter ZONE_FORMATTER = DateTimeFormat.forPattern("ZZ");

    public DateTimeCodec(TupleType tupleType) {
        super(tupleType, DateTime.class);
        List<DataType> types = tupleType.getComponentTypes();
        Preconditions.checkArgument(types.size() == 2 && types.get(0).equals(DataType.timestamp()) && types.get(1).equals(DataType.varchar()), "Expected tuple<timestamp,varchar>, got %s", tupleType);
    }

    @Override
    protected DateTime newInstance() {
        return null;
    }

    @Override
    protected ByteBuffer serializeField(DateTime source, int index, ProtocolVersion protocolVersion) {
        if (index == 0) {
            long millis = source.getMillis();
            return DateTimeCodec.bigint().serializeNoBoxing(millis, protocolVersion);
        }
        if (index == 1) {
            return DateTimeCodec.varchar().serialize(ZONE_FORMATTER.print(source), protocolVersion);
        }
        throw new IndexOutOfBoundsException("Tuple index out of bounds. " + index);
    }

    @Override
    protected DateTime deserializeAndSetField(ByteBuffer input, DateTime target, int index, ProtocolVersion protocolVersion) {
        if (index == 0) {
            long millis = DateTimeCodec.bigint().deserializeNoBoxing(input, protocolVersion);
            return new DateTime(millis);
        }
        if (index == 1) {
            String zoneId = DateTimeCodec.varchar().deserialize(input, protocolVersion);
            return target.withZone(DateTimeZone.forID(zoneId));
        }
        throw new IndexOutOfBoundsException("Tuple index out of bounds. " + index);
    }

    @Override
    protected String formatField(DateTime value, int index) {
        if (index == 0) {
            return ParseUtils.quote(value.withZone(DateTimeZone.UTC).toString());
        }
        if (index == 1) {
            return ParseUtils.quote(ZONE_FORMATTER.print(value));
        }
        throw new IndexOutOfBoundsException("Tuple index out of bounds. " + index);
    }

    @Override
    protected DateTime parseAndSetField(String input, DateTime target, int index) {
        if (index == 0) {
            if (ParseUtils.isQuoted(input)) {
                input = ParseUtils.unquote(input);
            }
            if (ParseUtils.isLongLiteral(input)) {
                try {
                    long millis = Long.parseLong(input);
                    return new DateTime(millis);
                }
                catch (NumberFormatException e) {
                    throw new InvalidTypeException(String.format("Cannot parse timestamp value from \"%s\"", input));
                }
            }
            try {
                return FORMATTER.parseDateTime(input);
            }
            catch (RuntimeException e) {
                throw new InvalidTypeException(String.format("Cannot parse timestamp value from \"%s\"", target));
            }
        }
        if (index == 1) {
            String zoneId = DateTimeCodec.varchar().parse(input);
            return target.withZone(DateTimeZone.forID(zoneId));
        }
        throw new IndexOutOfBoundsException("Tuple index out of bounds. " + index);
    }
}

