/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.datastax.driver.extras.codecs.enums;

import com.github.cassandra.jdbc.internal.datastax.driver.core.TypeCodec;
import com.github.cassandra.jdbc.internal.datastax.driver.extras.codecs.ParsingCodec;

public class EnumNameCodec<E extends Enum<E>>
extends ParsingCodec<E> {
    private final Class<E> enumClass;

    public EnumNameCodec(Class<E> enumClass) {
        this(TypeCodec.varchar(), enumClass);
    }

    public EnumNameCodec(TypeCodec<String> innerCodec, Class<E> enumClass) {
        super(innerCodec, enumClass);
        this.enumClass = enumClass;
    }

    @Override
    protected String toString(E value) {
        return value == null ? null : ((Enum)value).name();
    }

    @Override
    protected E fromString(String value) {
        return value == null ? null : (E)Enum.valueOf(this.enumClass, value);
    }
}

