/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.datastax.driver.extras.codecs.arrays;

import com.github.cassandra.jdbc.internal.datastax.driver.core.DataType;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ProtocolVersion;
import com.github.cassandra.jdbc.internal.datastax.driver.extras.codecs.arrays.AbstractPrimitiveArrayCodec;
import java.nio.ByteBuffer;

public class LongArrayCodec
extends AbstractPrimitiveArrayCodec<long[]> {
    public static final LongArrayCodec instance = new LongArrayCodec();

    public LongArrayCodec() {
        super(DataType.list(DataType.bigint()), long[].class);
    }

    @Override
    protected int sizeOfComponentType() {
        return 8;
    }

    @Override
    protected void serializeElement(ByteBuffer output, long[] array, int index, ProtocolVersion protocolVersion) {
        output.putLong(array[index]);
    }

    @Override
    protected void deserializeElement(ByteBuffer input, long[] array, int index, ProtocolVersion protocolVersion) {
        array[index] = input.getLong();
    }

    @Override
    protected void formatElement(StringBuilder output, long[] array, int index) {
        output.append(array[index]);
    }

    @Override
    protected void parseElement(String input, long[] array, int index) {
        array[index] = Long.parseLong(input);
    }

    @Override
    protected long[] newInstance(int size) {
        return new long[size];
    }
}

