/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.datastax.driver.extras.codecs.arrays;

import com.github.cassandra.jdbc.internal.datastax.driver.core.DataType;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ProtocolVersion;
import com.github.cassandra.jdbc.internal.datastax.driver.extras.codecs.arrays.AbstractPrimitiveArrayCodec;
import java.nio.ByteBuffer;

public class IntArrayCodec
extends AbstractPrimitiveArrayCodec<int[]> {
    public static final IntArrayCodec instance = new IntArrayCodec();

    public IntArrayCodec() {
        super(DataType.list(DataType.cint()), int[].class);
    }

    @Override
    protected int sizeOfComponentType() {
        return 4;
    }

    @Override
    protected void serializeElement(ByteBuffer output, int[] array, int index, ProtocolVersion protocolVersion) {
        output.putInt(array[index]);
    }

    @Override
    protected void deserializeElement(ByteBuffer input, int[] array, int index, ProtocolVersion protocolVersion) {
        array[index] = input.getInt();
    }

    @Override
    protected void formatElement(StringBuilder output, int[] array, int index) {
        output.append(array[index]);
    }

    @Override
    protected void parseElement(String input, int[] array, int index) {
        array[index] = Integer.parseInt(input);
    }

    @Override
    protected int[] newInstance(int size) {
        return new int[size];
    }
}

