/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.datastax.driver.extras.codecs.arrays;

import com.github.cassandra.jdbc.internal.datastax.driver.core.DataType;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ProtocolVersion;
import com.github.cassandra.jdbc.internal.datastax.driver.extras.codecs.arrays.AbstractPrimitiveArrayCodec;
import java.nio.ByteBuffer;

public class FloatArrayCodec
extends AbstractPrimitiveArrayCodec<float[]> {
    public static final FloatArrayCodec instance = new FloatArrayCodec();

    public FloatArrayCodec() {
        super(DataType.list(DataType.cfloat()), float[].class);
    }

    @Override
    protected int sizeOfComponentType() {
        return 4;
    }

    @Override
    protected void serializeElement(ByteBuffer output, float[] array, int index, ProtocolVersion protocolVersion) {
        output.putFloat(array[index]);
    }

    @Override
    protected void deserializeElement(ByteBuffer input, float[] array, int index, ProtocolVersion protocolVersion) {
        array[index] = input.getFloat();
    }

    @Override
    protected void formatElement(StringBuilder output, float[] array, int index) {
        output.append(array[index]);
    }

    @Override
    protected void parseElement(String input, float[] array, int index) {
        array[index] = Float.parseFloat(input);
    }

    @Override
    protected float[] newInstance(int size) {
        return new float[size];
    }
}

