/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.datastax.driver.core.querybuilder;

import com.github.cassandra.jdbc.internal.datastax.driver.core.CodecRegistry;
import com.github.cassandra.jdbc.internal.datastax.driver.core.ColumnMetadata;
import com.github.cassandra.jdbc.internal.datastax.driver.core.TableMetadata;
import com.github.cassandra.jdbc.internal.datastax.driver.core.querybuilder.BuiltStatement;
import com.github.cassandra.jdbc.internal.datastax.driver.core.querybuilder.Utils;
import java.util.Arrays;
import java.util.List;

public class Truncate
extends BuiltStatement {
    private final String table;

    Truncate(String keyspace, String table) {
        this(keyspace, table, null, null);
    }

    Truncate(TableMetadata table) {
        this(Truncate.escapeId(table.getKeyspace().getName()), Truncate.escapeId(table.getName()), Arrays.asList(new Object[table.getPartitionKey().size()]), table.getPartitionKey());
    }

    Truncate(String keyspace, String table, List<Object> routingKeyValues, List<ColumnMetadata> partitionKey) {
        super(keyspace, partitionKey, routingKeyValues);
        this.table = table;
    }

    @Override
    protected StringBuilder buildQueryString(List<Object> variables, CodecRegistry codecRegistry) {
        StringBuilder builder = new StringBuilder();
        builder.append("TRUNCATE ");
        if (this.keyspace != null) {
            Utils.appendName(this.keyspace, builder).append('.');
        }
        Utils.appendName(this.table, builder);
        return builder;
    }
}

