/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.datastax.driver.core.querybuilder;

import com.github.cassandra.jdbc.internal.datastax.driver.core.CodecRegistry;
import com.github.cassandra.jdbc.internal.datastax.driver.core.querybuilder.Utils;
import java.util.List;

public abstract class Assignment
extends Utils.Appendeable {
    final String name;

    private Assignment(String name) {
        this.name = name;
    }

    public String getColumnName() {
        return this.name;
    }

    abstract boolean isIdempotent();

    static class MapPutAssignment
    extends Assignment {
        private final Object key;
        private final Object value;

        MapPutAssignment(String name, Object key, Object value) {
            super(name);
            this.key = key;
            this.value = value;
        }

        @Override
        void appendTo(StringBuilder sb, List<Object> variables, CodecRegistry codecRegistry) {
            Utils.appendName(this.name, sb).append('[');
            Utils.appendValue(this.key, codecRegistry, sb, variables);
            sb.append("]=");
            Utils.appendValue(this.value, codecRegistry, sb, variables);
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.key) || Utils.containsBindMarker(this.value);
        }

        @Override
        boolean isIdempotent() {
            return true;
        }
    }

    static class CollectionAssignment
    extends Assignment {
        private final Object collection;
        private final boolean isAdd;
        private final boolean isIdempotent;

        CollectionAssignment(String name, Object collection, boolean isAdd, boolean isIdempotent) {
            super(name);
            this.collection = collection;
            this.isAdd = isAdd;
            this.isIdempotent = isIdempotent;
        }

        CollectionAssignment(String name, Object collection, boolean isAdd) {
            this(name, collection, isAdd, true);
        }

        @Override
        void appendTo(StringBuilder sb, List<Object> variables, CodecRegistry codecRegistry) {
            Utils.appendName(this.name, sb).append('=');
            Utils.appendName(this.name, sb).append(this.isAdd ? "+" : "-");
            Utils.appendValue(this.collection, codecRegistry, sb, variables);
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.collection);
        }

        @Override
        public boolean isIdempotent() {
            return this.isIdempotent;
        }
    }

    static class ListSetIdxAssignment
    extends Assignment {
        private final int idx;
        private final Object value;

        ListSetIdxAssignment(String name, int idx, Object value) {
            super(name);
            this.idx = idx;
            this.value = value;
        }

        @Override
        void appendTo(StringBuilder sb, List<Object> variables, CodecRegistry codecRegistry) {
            Utils.appendName(this.name, sb).append('[').append(this.idx).append("]=");
            Utils.appendValue(this.value, codecRegistry, sb, variables);
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.value);
        }

        @Override
        boolean isIdempotent() {
            return true;
        }
    }

    static class ListPrependAssignment
    extends Assignment {
        private final Object value;

        ListPrependAssignment(String name, Object value) {
            super(name);
            this.value = value;
        }

        @Override
        void appendTo(StringBuilder sb, List<Object> variables, CodecRegistry codecRegistry) {
            Utils.appendName(this.name, sb).append('=');
            Utils.appendValue(this.value, codecRegistry, sb, variables);
            sb.append('+');
            Utils.appendName(this.name, sb);
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.value);
        }

        @Override
        boolean isIdempotent() {
            return false;
        }
    }

    static class CounterAssignment
    extends Assignment {
        private final Object value;
        private final boolean isIncr;

        CounterAssignment(String name, Object value, boolean isIncr) {
            super(name);
            if (!isIncr && value instanceof Long && (Long)value < 0L) {
                this.value = -((Long)value).longValue();
                this.isIncr = true;
            } else {
                this.value = value;
                this.isIncr = isIncr;
            }
        }

        @Override
        void appendTo(StringBuilder sb, List<Object> variables, CodecRegistry codecRegistry) {
            Utils.appendName(this.name, sb).append('=');
            Utils.appendName(this.name, sb).append(this.isIncr ? "+" : "-");
            Utils.appendValue(this.value, codecRegistry, sb, variables);
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.value);
        }

        @Override
        boolean isIdempotent() {
            return false;
        }
    }

    static class SetAssignment
    extends Assignment {
        private final Object value;

        SetAssignment(String name, Object value) {
            super(name);
            this.value = value;
        }

        @Override
        void appendTo(StringBuilder sb, List<Object> variables, CodecRegistry codecRegistry) {
            Utils.appendName(this.name, sb);
            sb.append('=');
            Utils.appendValue(this.value, codecRegistry, sb, variables);
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.value);
        }

        @Override
        boolean isIdempotent() {
            return Utils.isIdempotent(this.value);
        }
    }
}

